/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Util;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Injector {
    private static final Map<ClassLoader, WeakReference<Injector>> injectors = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, Class> classes = new HashMap<String, Class>();
    private final ClassLoader parent;
    private static final Method defineClass;
    private static final Method resolveClass;

    static Class inject(ClassLoader cl, String className, byte[] image) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.inject(className, image);
        }
        return null;
    }

    static Class find(ClassLoader cl, String className) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.find(className);
        }
        return null;
    }

    private static Injector get(ClassLoader cl) {
        Injector injector = null;
        WeakReference<Injector> wr = injectors.get(cl);
        if (wr != null) {
            injector = (Injector)wr.get();
        }
        if (injector == null) {
            try {
                injector = new Injector(cl);
                injectors.put(cl, new WeakReference<Injector>(injector));
            }
            catch (SecurityException e) {
                logger.log(Level.FINE, "Unable to set up a back-door for the injector", e);
                return null;
            }
        }
        return injector;
    }

    private Injector(ClassLoader parent) {
        this.parent = parent;
        assert (parent != null);
    }

    private synchronized Class inject(String className, byte[] image) {
        Class c = this.classes.get(className);
        if (c == null) {
            try {
                c = (Class)defineClass.invoke((Object)this.parent, className.replace('/', '.'), image, 0, image.length);
                resolveClass.invoke((Object)this.parent, c);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            catch (InvocationTargetException e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            catch (SecurityException e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            this.classes.put(className, c);
        }
        return c;
    }

    private synchronized Class find(String className) {
        return this.classes.get(className);
    }

    static {
        try {
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            resolveClass = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                defineClass.setAccessible(true);
                resolveClass.setAccessible(true);
                return null;
            }
        });
    }
}

