/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import javax.management.j2ee.statistics.CountStatistic;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.util.StringUtil;
import jeus.util.concurrent50.concurrent.atomic.AtomicLong;

public class CountStatisticImpl
extends StatisticImpl
implements CountStatistic {
    private AtomicLong count = new AtomicLong(0L);

    public CountStatisticImpl(String pName, String pUnit, String pDesc) {
        super(pName, pUnit, pDesc);
    }

    public CountStatisticImpl(String sName, String pName, String pUnit, String pDesc) {
        super(sName, pName, pUnit, pDesc);
    }

    public long getCount() {
        return this.count.get();
    }

    public void increase() {
        this.count.getAndIncrement();
        this.sampled();
    }

    public void increase(long amount) {
        this.count.getAndAdd(amount);
        this.sampled();
    }

    public void decrease() {
        this.count.getAndDecrement();
        this.sampled();
    }

    public void decrease(long amount) {
        this.count.set(this.count.get() - amount);
        this.sampled();
    }

    public void setValue(long value) {
        this.count.set(value);
        this.sampled();
    }

    public void reset() {
        this.count.set(0L);
        this.sampled();
    }

    public void update(CountStatisticImpl stats) {
        super.update(stats);
        this.count.set(stats.count.get());
    }

    public String getShortStats() {
        return "C:" + this.count;
    }

    public String getStatisticName() {
        return "CountStatistic";
    }

    public String toString() {
        String stat = super.toString();
        StringBuffer buffer = new StringBuffer(stat).append(StringUtil.lineSeparator);
        buffer.append('\t').append("count : ").append(this.count).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

