/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import javax.management.j2ee.statistics.TimeStatistic;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.util.StringUtil;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic {
    protected long count;
    protected long maxTime = Long.MIN_VALUE;
    protected long minTime = Long.MAX_VALUE;
    protected long totalTime;

    public TimeStatisticImpl(String pName, String pUnit, String pDesc) {
        super(pName, pUnit, pDesc);
    }

    public TimeStatisticImpl(String sName, String pName, String pUnit, String pDesc) {
        super(sName, pName, pUnit, pDesc);
    }

    public long getCount() {
        return this.count;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void addData(long time) {
        this.totalTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
        ++this.count;
        this.sampled();
    }

    public void reset() {
        this.count = 0L;
        this.maxTime = Long.MIN_VALUE;
        this.minTime = Long.MAX_VALUE;
        this.totalTime = 0L;
    }

    public String getShortStats() {
        return "T:" + this.minTime + ":" + this.maxTime + ":" + this.totalTime;
    }

    public String getStatisticName() {
        return "TimeStatistic";
    }

    public void update(TimeStatisticImpl stats) {
        super.update(stats);
        this.count = stats.count;
        this.maxTime = stats.maxTime;
        this.minTime = stats.minTime;
        this.totalTime = stats.totalTime;
    }

    public String toString() {
        String stat = super.toString();
        StringBuffer buffer = new StringBuffer(stat).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Sample Count : ").append(this.count).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Min time : ").append(this.minTime).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Max time : ").append(this.maxTime).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Total time : ").append(this.totalTime).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

