/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.AbstractArchive;
import org.apache.commons.compress.ArchiveEntry;
import org.apache.commons.compress.ArchiveException;
import org.apache.commons.compress.UnpackException;
import org.apache.commons.compress.archivers.zip.ZipEntry;
import org.apache.commons.compress.archivers.zip.ZipOutputStream;

public class ZipArchive
extends AbstractArchive {
    private static final int BUFFER = 2048;
    private static final byte[] HEADER = new byte[]{80, 75, 3, 4};
    private static String DEFAULT_FILE_EXTENSION = "zip";
    private static final String ARCHIVER_NAME = "zip";

    protected void doUnpack(File unpackDir) throws UnpackException {
        BufferedOutputStream destination = null;
        FileInputStream fInputStream = null;
        try {
            fInputStream = new FileInputStream(this.getArchive());
        }
        catch (FileNotFoundException e) {
            throw new UnpackException("SourceFile could not be found.", e);
        }
        ZipInputStream zInputStream = null;
        try {
            java.util.zip.ZipEntry entry;
            zInputStream = new ZipInputStream(new BufferedInputStream(fInputStream));
            while ((entry = zInputStream.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                String fosString = unpackDir.getAbsolutePath() + File.separator + entry.getName();
                FileOutputStream fos = new FileOutputStream(fosString);
                destination = new BufferedOutputStream(fos, 2048);
                while ((count = zInputStream.read(data, 0, 2048)) != -1) {
                    destination.write(data, 0, count);
                }
                destination.flush();
                destination.close();
            }
        }
        catch (IOException e) {
            throw new UnpackException("Exception while unpacking.", e);
        }
        finally {
            try {
                if (zInputStream != null) {
                    zInputStream.close();
                }
            }
            catch (IOException e1) {
                throw new UnpackException("Exception while unpacking.", e1);
            }
        }
    }

    protected void doSave(OutputStream output) throws ArchiveException {
        BufferedInputStream origin = null;
        byte[] data = new byte[2048];
        Iterator iterator = this.getEntryIterator();
        if (!iterator.hasNext()) {
            throw new ArchiveException("There must be at least one file to be pack.");
        }
        DeflaterOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(output));
            while (iterator.hasNext()) {
                int count;
                ArchiveEntry archiveEntry = (ArchiveEntry)iterator.next();
                InputStream fInputStream = archiveEntry.getStream();
                origin = new BufferedInputStream(fInputStream, 2048);
                ZipEntry entry = new ZipEntry(archiveEntry.getName());
                ((ZipOutputStream)out).putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    ((ZipOutputStream)out).write(data, 0, count);
                }
                origin.close();
            }
        }
        catch (IOException e) {
            throw new ArchiveException("Creation of this archive failed cause of IOExceptions.", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                throw new ArchiveException("Creation of this archive failed cause of IOExceptions.", e1);
            }
        }
    }

    public String getName() {
        return ARCHIVER_NAME;
    }

    public String getDefaultFileExtension() {
        return DEFAULT_FILE_EXTENSION;
    }

    public byte[] getHeader() {
        return HEADER;
    }
}

