/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.jms.client.ClientMessageFabricator;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.comm.ClientBlockingMessageWriter;
import jeus.jms.client.comm.JMSServerEntryContext;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.comm.IntermediateMessageAssembler;
import jeus.jms.common.comm.JMSContentHandlerCreator;
import jeus.jms.common.comm.MessageFabricator;
import jeus.jms.common.comm.MessageWriter;
import jeus.jms.common.comm.SSLParameterFactory;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateEntryMessage;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.Timer;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.util.concurrent50.concurrent.atomic.AtomicBoolean;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public class JMSRemoteServerEntry
extends JMSServerEntry
implements JMSRemoteEntry,
Freezer,
ConnectionListenerFactory {
    private static BoundedInteger idGenerator = BoundedInteger.getIncrementor();
    private Endpoint endpoint;
    private SocketStream stream;
    private MessageWriter writer;
    private Map assemblers = new HashMap();
    private boolean recovered = false;
    private int selectorType;
    private boolean useDirectByteBuffer;
    private ReconnectTask reconnectTask;
    private MessageFabricator fabricator = new ClientMessageFabricator(this);

    public JMSRemoteServerEntry(JMSServerEntryContext entryContext) throws IOException {
        super(entryContext);
        this.createEndpoint();
        this.connect();
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return this;
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2601_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2601_LEVEL, JeusMessage_JMS2._2601, sockStream);
        }
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
        this.stream = sockStream;
        this.stream.getSocket().setSoTimeout(0);
        AdminMessage adminMessage = (AdminMessage)piggybackedData;
        if (adminMessage.getOperationID() != 16) {
            throw new IOException("failed to negotiate : " + adminMessage.getException().toString());
        }
        CreateEntryMessage reply = (CreateEntryMessage)piggybackedData;
        this.setId(reply.getRequestID());
        this.brokerID = reply.getBrokerID();
        this.brokerName = reply.getBrokerName();
        this.recovered = reply.getBooleanFlag();
        if (this.writer != null) {
            this.writer.setSocketStream(this.stream);
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2602_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2602_LEVEL, JeusMessage_JMS2._2602, new Object[]{new Short(this.brokerID), this.brokerName});
        }
    }

    public void runDelegatedTask(Runnable processor, boolean isReplyPacket, Object message) {
        processor.run();
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2603_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2603_LEVEL, JeusMessage_JMS2._2603, new Object[]{new Short(this.brokerID), this.brokerName, piggybackedData});
        }
        long requestID = this.stream != null && this.stream.isEstablished() ? this.id : -1L;
        CreateEntryMessage createEntryMessage = MessageUtil.createEstablishMessage((byte)13, this.brokerName, requestID, this.xaRecovery);
        createEntryMessage.setBrokerID(this.brokerID);
        return createEntryMessage;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public SocketStream getSocketStream() {
        return this.stream;
    }

    public void setSocketStream(SocketStream stream) throws IOException {
        if (this.isSocketStreamUpdatable()) {
            this.stream = stream;
            this.writer.setSocketStream(stream);
        }
    }

    public void connectionClosed(Exception e) {
        this.connectionClosed(e, this.stream);
    }

    public IntermediateMessageAssembler getMessageAssembler(int partialID) {
        return (IntermediateMessageAssembler)this.assemblers.get(new Integer(partialID));
    }

    public void addMessageAssembler(int partialID, IntermediateMessageAssembler assembler) {
        this.assemblers.put(new Integer(partialID), assembler);
    }

    public void removeMessageAssembler(int partialID) {
        this.assemblers.remove(new Integer(partialID));
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) throws Exception {
        byte[] data = (byte[])obj;
        MessageContainer message = this.fabricator.fabricate(data);
        if (message != null) {
            this.recvData(message);
        }
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (this.closed.get()) {
            return;
        }
        if (exception == null) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2604_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2604_LEVEL, JeusMessage_JMS2._2604, this);
            }
        } else if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2605_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2605_LEVEL, JeusMessage_JMS2._2605, this, (Throwable)exception);
        }
        if (this.writer != null) {
            this.writer.connectionClosed();
        }
        this.closeSocketStream();
        this.reconnect();
    }

    private void closeSocketStream() {
        if (this.stream != null && this.stream.getCloseState() == 0) {
            this.stream.destroy();
        }
        this.stream = null;
    }

    public void start() {
        this.writer.setSuspend(false);
    }

    public void cancelConnect() {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
        }
    }

    public boolean isSocketStreamUpdatable() {
        return this.stream == null || this.stream.getCloseState() != 0;
    }

    public String getAddress() {
        return this.stream == null ? "null" : this.stream.getHostName() + ":" + this.stream.getPort();
    }

    public void sendData(MessageContainer message) throws JMSException {
        message.setEntryID(this.id);
        message.setBrokerID(this.brokerID);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2606_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2606_LEVEL, JeusMessage_JMS2._2606, new Object[]{message, message.isDelayed() ? "delayed" : "immediate"});
        }
        if (!message.isDelayed()) {
            try {
                this.writer.enqueue(this.executor, message);
            }
            catch (Exception e) {
                throw JMSExceptionFactory.createJMSException("failed to send " + message + " for " + e.getMessage(), e);
            }
        }
        try {
            this.writer.enqueue(message);
        }
        catch (IOException e) {
            throw JMSExceptionFactory.createJMSException("failed to send " + message + " for " + e.getMessage(), (Exception)e);
        }
    }

    public void sendDirect(MessageContainer packet) throws JMSException {
        packet.setEntryID(this.id);
        packet.setBrokerID(this.brokerID);
        try {
            this.writer.executeDirect(packet);
        }
        catch (Exception e) {
            throw new JMSException("failed to send for " + e.toString());
        }
    }

    public void prepareShutdown() {
        block4: {
            if (!this.closed.commit(false, true)) {
                return;
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.prepareShutdown();
            }
            try {
                this.sendCloseMessage();
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2607_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS2._2607_LEVEL, JeusMessage_JMS2._2607, e);
            }
        }
    }

    public void shutdown() {
        super.shutdown();
        this.closeSocketStream();
        if (this.endpoint != null && this.endpoint.isExported()) {
            this.endpoint.unexport();
            this.endpoint = null;
        }
    }

    public boolean isRemote() {
        return true;
    }

    public void flushWorks() {
        this.writer.flush();
    }

    private void createEndpoint() {
        if (JMSProperties.isUpperJDK4() && !this.entryContext.isSslSupport() && !JMSProperties.CLIENT_FORCE_SOCKET_SELECTOR) {
            this.selectorType = 3;
            this.useDirectByteBuffer = JMSProperties.USE_DIRECT_BUFFER;
        } else {
            this.selectorType = 2;
        }
        String endpointName = "JMSRemoteServerEntry-Endpoint-" + idGenerator.getNextValue();
        IOComponentCreator ioComCreator = IOComponentCreator.createBlockingCreator((String)endpointName, (int)this.selectorType, (boolean)true);
        JMSContentHandlerCreator contentHandlerCreator = new JMSContentHandlerCreator(this.useDirectByteBuffer);
        SSLParameterFactory.SSLParameter param = this.createSSLParameter();
        this.endpoint = new Endpoint(endpointName, ioComCreator, (SocketID)new NoListenID(), (StreamContentHandlerCreator)contentHandlerCreator, (ConnectionListenerFactory)this, param.getSSLContext(), param.getSSLServerSocketFactory(), true);
    }

    private SSLParameterFactory.SSLParameter createSSLParameter() {
        if (!this.entryContext.isSslSupport()) {
            return SSLParameterFactory.NULL_PARAMETER;
        }
        String keyStoreType = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.keystore.type", (String)"JKS");
        String keyStorePass = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.keystore.passphrase", (String)"changeit");
        String keyStorePath = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.keystore.file");
        if (keyStorePath == null) {
            throw new IllegalArgumentException("Key store file must be set.");
        }
        String keyManagementAlgorithm = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.keymanagement.algorithm", (String)"SunX509");
        String trustStoreType = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.truststore.type", (String)"JKS");
        String trustStorePass = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.truststore.passphrase", (String)"changeit");
        String trustStorePath = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.truststore.file");
        if (trustStorePath == null) {
            throw new IllegalArgumentException("Trust store file must be set.");
        }
        String trustManagementAlgorithm = JMSProperties.getSystemProperty((String)"jeus.jms.ssl.trustmanagement.algorithm", (String)"SunX509");
        Properties props = new Properties();
        props.put("jeus.jms.ssl.keystore.type", keyStoreType);
        props.put("jeus.jms.ssl.keystore.passphrase", keyStorePass);
        props.put("jeus.jms.ssl.keystore.file", keyStorePath);
        props.put("jeus.jms.ssl.keymanagement.algorithm", keyManagementAlgorithm);
        props.put("jeus.jms.ssl.truststore.type", trustStoreType);
        props.put("jeus.jms.ssl.truststore.passphrase", trustStorePass);
        props.put("jeus.jms.ssl.truststore.file", trustStorePath);
        props.put("jeus.jms.ssl.trustmanagement.algorithm", trustManagementAlgorithm);
        return SSLParameterFactory.getFactory().createSSLParameter(props, true);
    }

    private void connect() throws IOException {
        Timer timer = new Timer(JMSProperties.getClientConnectTimeout());
        this.establish(timer, false);
    }

    private boolean isForcedReconnect() {
        JeusConnection[] cons = this.connections.values().toArray(new JeusConnection[0]);
        for (int i = 0; i < cons.length; ++i) {
            JeusConnection con = cons[i];
            if (!con.isForcedReconnect()) continue;
            return true;
        }
        return false;
    }

    private void reconnect() {
        boolean forced = this.isForcedReconnect();
        if (forced || JMSProperties.DO_CONNECTION_FAILOVER) {
            this.freezeConnections();
            List works = this.writer != null ? this.writer.removeWorks() : Collections.EMPTY_LIST;
            try {
                Timer timer = new Timer(JMSProperties.getClientReconnectTimeout());
                this.establish(timer, true);
                if (!this.recovered && !this.connections.isEmpty()) {
                    this.recoverFacility();
                    this.recoverWorks(works);
                }
                this.thawConnections();
                if (this.writer != null) {
                    this.writer.enqueueWorks(works);
                }
            }
            catch (JMSException e) {
                this.failedToReconnect(forced, e);
            }
            catch (Exception e) {
                this.failedToReconnect(forced, JMSExceptionFactory.createJMSException(e.getMessage(), e));
            }
        } else {
            this.exceptionOccurred(new JMSException("Connection Closed"));
            this.writer.shutdown();
            this.cancelOutBoundRequests();
        }
    }

    private void failedToReconnect(boolean forced, JMSException e) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2608_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2608_LEVEL, JeusMessage_JMS2._2608, e);
        }
        this.tryToConnect = true;
        boolean executed = this.exceptionOccurred(e);
        if (forced || JMSProperties.TRY_CONNECT_EVER && (!executed || JMSProperties.TRY_CONNECT_EVER_FOR_EXCEPTION_LISTENER)) {
            this.cancelOutBoundRequests();
            this.closeSocketStream();
            this.executeConnector(forced);
        } else {
            this.thawConnections();
            this.exceptionOccurred(new JMSException("Connection Closed"));
            this.cancelOutBoundRequests();
            if (this.writer != null) {
                this.writer.shutdown();
            }
            this.closeSocketStream();
        }
    }

    protected void cancelOutBoundRequests() {
        super.cancelOutBoundRequests();
        this.writer.clearWorks();
    }

    private void recoverWorks(List works) {
        int minObserverID = Integer.MAX_VALUE;
        for (MessageContainer packet : works) {
            packet.recover(this.brokerID, this.id);
            int observerID = packet.getObserverID();
            if (minObserverID <= observerID) continue;
            minObserverID = observerID;
        }
        this.cancelSentOutboudRequests(minObserverID);
    }

    private void cancelSentOutboudRequests(int minObserverID) {
        ArrayList<Integer> sents = new ArrayList<Integer>();
        Map all = this.entryContext.getRequestManager().getAll();
        for (Integer key : all.keySet()) {
            if (key >= minObserverID) continue;
            sents.add(key);
        }
        JMSException ex = new JMSException("failed to recover previous facilities. so observers are unable to get replies.");
        this.entryContext.getRequestManager().cancelObserversByException(sents, ex);
    }

    private void freezeConnections() {
        JeusConnection[] cons = this.connections.values().toArray(new JeusConnection[0]);
        for (int i = 0; i < cons.length; ++i) {
            JeusConnection con = cons[i];
            con.freeze(this);
        }
    }

    private void thawConnections() {
        JeusConnection[] cons = this.connections.values().toArray(new JeusConnection[0]);
        for (int i = 0; i < cons.length; ++i) {
            JeusConnection con = cons[i];
            con.thaw(this);
        }
    }

    protected void takeover(short activeBrokerID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2609_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2609_LEVEL, JeusMessage_JMS2._2609, new Short(activeBrokerID));
        }
        this.closeSocketStream();
    }

    private void executeConnector(boolean forced) {
        if (!Thread.interrupted()) {
            this.reconnectTask = new ReconnectTask(forced);
            this.executor.executeForced(this.reconnectTask);
        }
    }

    private void recoverFacility() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2610_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2610_LEVEL, JeusMessage_JMS2._2610, this);
        }
        this.writer.startRecovery();
        try {
            this.recoverConnections();
            this.writer.endRecovery();
            this.writer.flush();
        }
        catch (JMSException ex) {
            this.id = -1L;
            this.writer.failedRecovery();
            throw ex;
        }
    }

    private void recoverConnections() throws JMSException {
        JeusConnection[] recover = this.connections.values().toArray(new JeusConnection[this.connections.size()]);
        for (int i = 0; i < recover.length; ++i) {
            recover[i].recoverFacility();
        }
    }

    private boolean exceptionOccurred(JMSException ex) {
        boolean executed = false;
        JeusConnection[] targets = this.connections.values().toArray(new JeusConnection[this.connections.size()]);
        for (int i = 0; i < targets.length; ++i) {
            try {
                executed = targets[i].exceptionOccurred(this, ex);
                continue;
            }
            catch (Throwable t) {
                executed = true;
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2611_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2611_LEVEL, JeusMessage_JMS2._2611, t);
                }
                Thread.currentThread().interrupt();
            }
        }
        return executed;
    }

    private void establish(Timer timer, boolean reconnect) throws IOException {
        try {
            SocketStream newStream;
            SocketStream socketStream = newStream = reconnect ? this.entryContext.reconnect(this.endpoint, timer) : this.entryContext.connect(this.endpoint, timer);
            if (!reconnect) {
                this.writer = new ClientBlockingMessageWriter(this, newStream);
            }
        }
        catch (IOException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2612_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2612_LEVEL, JeusMessage_JMS2._2612, e);
            }
            this.closeSocketStream();
            throw e;
        }
    }

    public boolean useDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    private class ReconnectTask
    implements Runnable {
        private AtomicBoolean cancelled = new AtomicBoolean(false);
        private boolean forced;

        public ReconnectTask(boolean forced) {
            this.forced = forced;
        }

        public void run() {
            List works;
            Timer timer = new Timer(0L);
            List list = works = JMSRemoteServerEntry.this.writer != null ? JMSRemoteServerEntry.this.writer.removeWorks() : Collections.EMPTY_LIST;
            while (!Thread.interrupted() && !this.cancelled.get()) {
                try {
                    JMSRemoteServerEntry.this.establish(new Timer(JMSProperties.getClientReconnectTimeout()), true);
                    if (!JMSRemoteServerEntry.this.recovered && !JMSRemoteServerEntry.this.connections.isEmpty()) {
                        JMSRemoteServerEntry.this.recoverFacility();
                        JMSRemoteServerEntry.this.recoverWorks(works);
                    }
                    if (JMSRemoteServerEntry.this.writer == null) break;
                    JMSRemoteServerEntry.this.writer.enqueueWorks(works);
                    break;
                }
                catch (JMSException ex) {
                    JMSRemoteServerEntry.this.exceptionOccurred(ex);
                    JMSRemoteServerEntry.this.closeSocketStream();
                }
                catch (Exception ex) {
                    JMSRemoteServerEntry.this.exceptionOccurred(new JMSException(ex.toString()));
                    JMSRemoteServerEntry.this.closeSocketStream();
                }
                timer.elapsWhile(JMSServerEntry.RECONNECT_MIN_INTERVAL);
            }
            JMSRemoteServerEntry.this.thawConnections();
        }

        public void cancel() {
            if (!this.forced) {
                this.cancelled.set(true);
            }
        }
    }
}

