/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client;

import java.util.HashSet;
import javax.jms.JMSException;
import jeus.jms.client.JMSRemoteServerEntryFactory;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.comm.JMSServerEntryContext;
import jeus.jms.common.util.JMSExceptionFactory;

public abstract class JMSServerEntryFactory {
    public static JMSServerEntry createServerEntry(HashSet addresses, String policyType, int maxThread, boolean sslSupport, boolean xaRecovery) throws JMSException {
        JMSServerEntryContext entryContext = new JMSServerEntryContext(addresses, policyType, maxThread, sslSupport, xaRecovery);
        return JMSServerEntryFactory.createServerEntry(entryContext);
    }

    public static JMSServerEntry createServerEntry(JMSServerEntryContext entryContext) throws JMSException {
        JMSServerEntryFactory factory = null;
        if (entryContext.hasLocalBrokerAddress()) {
            try {
                factory = (JMSServerEntryFactory)Class.forName("jeus.jms.server.JMSLocalServerEntryFactory").newInstance();
            }
            catch (Exception e) {
                throw JMSExceptionFactory.createJMSException("failed to create JMSServerEntryFactory.", e);
            }
        }
        if (factory == null) {
            factory = new JMSRemoteServerEntryFactory();
        }
        return factory.createServerEntryInternal(entryContext);
    }

    protected abstract JMSServerEntry createServerEntryInternal(JMSServerEntryContext var1) throws JMSException;
}

