/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.comm;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.comm.BrokerSelectionPolicy;
import jeus.jms.common.comm.BrokerSelectionPolicyFactory;
import jeus.jms.common.util.JMSRequestManager;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.common.util.Timer;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public class JMSServerEntryContext {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private int maxThread;
    private HashSet addresses;
    private JMSServiceChannelAddress current;
    private JMSRequestManager manager;
    private boolean sslSupport;
    private boolean xaRecovery;
    private BrokerSelectionPolicy policy;
    public static final Executor THREAD_POOL = PooledExecutorFactory.createPooledExecutor((String)"JMS_CLIENT_THREAD", (int)JMSProperties.CLIENT_MAX_THREAD, (int)10, (long)60000L);

    public JMSServerEntryContext(HashSet addresses, String policyType, int maxThread, boolean sslSupport, boolean xaRecovery) {
        this.addresses = addresses;
        this.maxThread = maxThread;
        this.manager = new JMSRequestManager();
        this.policy = BrokerSelectionPolicyFactory.createBrokerSelectionPolicy(policyType, addresses);
        this.sslSupport = sslSupport;
        this.xaRecovery = xaRecovery;
    }

    private void checkCurrent() {
        if (this.current == null) {
            throw new IllegalStateException("current connected service channel is null.");
        }
    }

    public short getBrokerID() {
        this.checkCurrent();
        return this.current.getBrokerID();
    }

    public String getBrokerName() {
        this.checkCurrent();
        return this.current.getBrokerName();
    }

    public JMSRequestManager getRequestManager() {
        return this.manager;
    }

    public SerialExecutor getSerialExecutor() {
        return new SerialExecutor(THREAD_POOL);
    }

    public String getCurrentBrokerName() {
        this.checkCurrent();
        return this.current.getBrokerName();
    }

    public boolean isSslSupport() {
        return this.sslSupport;
    }

    public boolean isXaRecovery() {
        return this.xaRecovery;
    }

    public SocketStream reconnect(Endpoint endpoint, Timer timer) throws IOException {
        while (timer.remaining() > 0L) {
            Enumeration enumAddrs = this.policy.getReconnectServiceChannelAddresses(this.current);
            while (enumAddrs.hasMoreElements()) {
                JMSServiceChannelAddress addr = (JMSServiceChannelAddress)enumAddrs.nextElement();
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2051_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2051_LEVEL, JeusMessage_JMS2._2051, new Object[]{addr, Thread.currentThread(), new Long(timer.remaining())});
                }
                try {
                    SocketStream stream = endpoint.getSocketStream((SocketID)addr);
                    this.current = addr;
                    return stream;
                }
                catch (IOException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2052_LEVEL)) continue;
                    LogUtils.log(logger, JeusMessage_JMS2._2052_LEVEL, JeusMessage_JMS2._2052, addr, (Throwable)e);
                }
            }
            timer.elapsWhile(JMSServerEntry.RECONNECT_MIN_INTERVAL);
        }
        throw new IOException("failed to connect");
    }

    public SocketStream connect(Endpoint endpoint, Timer timer) throws IOException {
        while (timer.remaining() > 0L) {
            Enumeration enumAddrs = this.policy.getServiceChannelAddresses();
            while (enumAddrs.hasMoreElements()) {
                JMSServiceChannelAddress addr = (JMSServiceChannelAddress)enumAddrs.nextElement();
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2053_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2053_LEVEL, JeusMessage_JMS2._2053, new Object[]{addr, Thread.currentThread(), new Long(timer.remaining())});
                }
                try {
                    SocketStream stream = endpoint.getSocketStream((SocketID)addr);
                    this.current = addr;
                    return stream;
                }
                catch (IOException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2054_LEVEL)) continue;
                    LogUtils.log(logger, JeusMessage_JMS2._2054_LEVEL, JeusMessage_JMS2._2054, addr, (Throwable)e);
                }
            }
            timer.elapsWhile(JMSServerEntry.RECONNECT_MIN_INTERVAL);
        }
        throw new IOException("failed to connect");
    }

    public boolean hasLocalBrokerAddress() {
        return JMSServiceChannelAddress.hasLocalAddress(this.addresses);
    }

    public String toString() {
        if (this.current != null) {
            return this.current.getBrokerName() + "[" + this.current + "]";
        }
        return super.toString() + "[null current socket] : " + this.addresses;
    }
}

