/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.event;

import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;
import jeus.jms.client.event.EventActionListener;
import jeus.jms.client.event.EventMessage;
import jeus.jms.client.event.EventRequestor;
import jeus.jms.client.event.EventService;
import jeus.jms.client.event.EventSubscriber;
import jeus.jms.client.event.EventTopic;
import jeus.jms.client.event.JeusEventSubscriber;
import jeus.jms.client.event.JeusEventTopic;
import jeus.jms.common.event.ParamSet;
import jeus.jms.common.message.MessageProperty;
import jeus.jms.common.message.UserMessage;

public class JeusEventService
implements EventService {
    private final Connection conn;
    private final Session sess;
    private MessageProducer prod;

    public JeusEventService(Connection conn, Session sess) throws JMSException {
        this.conn = conn;
        this.sess = sess;
        this.initialize();
    }

    private void initialize() throws JMSException {
        this.prod = this.sess.createProducer(null);
        this.conn.start();
    }

    public EventSubscriber createEventSubscriber(String evaluator, EventActionListener actionListener, EventTopic eventTopic) throws JMSException {
        return this.createEventSubscriber(evaluator, actionListener, eventTopic, false, null, null);
    }

    public EventSubscriber createEventSubscriber(String evaluator, EventActionListener actionListener, EventTopic eventTopic, boolean isDurable, String durableName, String clientID) throws JMSException {
        if (isDurable && clientID != null) {
            this.conn.setClientID(clientID);
        }
        return new JeusEventSubscriber(this.sess, evaluator, actionListener, eventTopic, isDurable, durableName);
    }

    public EventMessage createEventMessage(ParamSet conditions) throws JMSException {
        return new JeusEventMessage(null, conditions, null);
    }

    public EventMessage createEventMessage(EventTopic eventTopic, ParamSet conditions) throws JMSException {
        return new JeusEventMessage(eventTopic, conditions, null);
    }

    public EventMessage createEventMessage(EventTopic eventTopic, ParamSet conditions, ParamSet contents) throws JMSException {
        return new JeusEventMessage(eventTopic, conditions, contents);
    }

    public EventTopic createEventTopic(String topicName) throws JMSException {
        return this.createEventTopic(null, topicName);
    }

    public EventTopic createEventTopic(String brokerName, String topicName) throws JMSException {
        String prefix = "!create=";
        String command = brokerName != null ? prefix + brokerName + ":" + topicName : prefix + topicName;
        Topic topic = this.sess.createTopic(command);
        return new JeusEventTopic(this.sess, topic);
    }

    public EventTopic getEventTopic(String topicName) throws JMSException {
        Topic topic = this.sess.createTopic(topicName);
        return new JeusEventTopic(this.sess, topic);
    }

    public EventTopic getEventTopic(Topic topic) throws JMSException {
        return new JeusEventTopic(this.sess, topic);
    }

    public EventRequestor getRequestor(String topicName) throws JMSException {
        return new JeusEventRequestor(this.sess, topicName);
    }

    public void close() throws JMSException {
        this.conn.close();
    }

    private class JeusEventMessage
    implements EventMessage {
        private EventTopic eventTopic;
        private MapMessage mapMessage;

        public JeusEventMessage(EventTopic eventTopic, ParamSet properties, ParamSet body) throws JMSException {
            this.eventTopic = eventTopic;
            this.mapMessage = JeusEventService.this.sess.createMapMessage();
            this.initProperties(properties);
            this.initBody(body);
        }

        public void initProperties(ParamSet properties) throws JMSException {
            if (properties == null) {
                return;
            }
            Set set = properties.getAll().entrySet();
            for (Map.Entry entry : set) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.setPropery(name, value);
            }
        }

        public void initBody(ParamSet body) throws JMSException {
            if (body == null) {
                return;
            }
            Set set = body.getAll().entrySet();
            for (Map.Entry entry : set) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.setBody(name, value);
            }
        }

        public Message getMessage() {
            return this.mapMessage;
        }

        public void setPropery(String name, Object value) throws JMSException {
            this.mapMessage.setObjectProperty(name, value);
        }

        public void setBody(String name, Object value) throws JMSException {
            this.mapMessage.setObject(name, value);
        }

        public void setEventTopic(EventTopic eventTopic) {
            this.eventTopic = eventTopic;
        }

        public void submit() throws JMSException {
            if (this.eventTopic == null) {
                throw new JMSException("submit failed: EventTopic is null");
            }
            JeusEventService.this.prod.send((Destination)this.eventTopic.getTopic(), (Message)this.mapMessage);
        }
    }

    private class JeusEventRequestor
    implements EventRequestor {
        private Topic topic;
        private TopicRequestor topicRequestor;

        public JeusEventRequestor(Session sess, String topicName) throws JMSException {
            this.topic = sess.createTopic(topicName);
            this.topicRequestor = new TopicRequestor((TopicSession)sess, this.topic);
        }

        public ParamSet request(EventMessage eventMessage) throws JMSException {
            Message jmsMessage = this.topicRequestor.request(eventMessage.getMessage());
            MessageProperty properties = ((UserMessage)jmsMessage).getProperties();
            return new ParamSet(properties);
        }
    }
}

