/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.connection;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.ClientFacility;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.TemporaryDestinationManager;
import jeus.jms.client.facility.TemporaryQueueManager;
import jeus.jms.client.facility.TemporaryTopicManager;
import jeus.jms.client.facility.connection.ConnectionFacility;
import jeus.jms.client.facility.connection.JeusConnectionMetaData;
import jeus.jms.client.facility.consumer.ConnectionConsumerFacility;
import jeus.jms.client.facility.consumer.ConsumerFacility;
import jeus.jms.client.facility.consumer.DurableConnectionConsumer;
import jeus.jms.client.facility.consumer.JeusConnectionConsumer;
import jeus.jms.client.facility.consumer.JeusLocalMessageConsumer;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.client.facility.session.SessionFacility;
import jeus.jms.client.util.ClientSerialExecutable;
import jeus.jms.common.JMSEntry;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.destination.JeusTemporaryQueue;
import jeus.jms.common.destination.JeusTemporaryTopic;
import jeus.jms.common.destination.TemporaryDestination;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateConnectionMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.message.admin.SetClientIDMessage;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutor;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public class JeusConnection
implements ConnectionFacility,
QueueConnection,
TopicConnection {
    protected final int type;
    protected Executor pool;
    private String clientID;
    private boolean fixed;
    private int connectionID = -1;
    private SynchronizedBoolean closePrepared;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private String userName;
    private String password;
    private boolean registable;
    private String connectionName;
    private ExceptionListener exceptionListener;
    private BoundedInteger sequence;
    private SerialExecution execution;
    private SerialExecutor executor;
    private JMSServerEntry entry;
    protected Hashtable sessions;
    protected Hashtable consumers;
    protected Hashtable temporaries;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JeusConnection(JMSServerEntry entry, String clientID, boolean fixed, int type) {
        this.entry = entry;
        this.type = type;
        this.clientID = clientID;
        this.fixed = fixed;
    }

    public JeusConnection(JMSServerEntry entry, String clientID, boolean fixed) {
        this(entry, clientID, fixed, 120);
    }

    public void createConnection(String userName, String password) throws JMSException {
        this.userName = userName;
        this.password = password;
        try {
            this.createFacility();
        }
        catch (JMSSecurityException secEx) {
            throw secEx;
        }
        catch (JMSException jmsEx) {
            throw jmsEx;
        }
        catch (Exception ex) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4200, null, ex);
        }
    }

    public boolean isRemote() {
        return this.entry.isRemote();
    }

    public JMSEntry getEntry() {
        return this.entry;
    }

    public void createFacility() throws JMSException {
        CreateConnectionMessage create = this.createConnectionMessage(false);
        AdminMessage reply = this.sendAndWaitReply(create);
        this.connectionID = reply.getConnectionID();
        if (this.clientID != null && !this.fixed) {
            this.clientID = this.clientID + "." + this.connectionID;
        }
        this.entry.registerConnection(this.connectionID, this);
        this.initialize();
    }

    private CreateConnectionMessage createConnectionMessage(boolean recover) {
        CreateConnectionMessage create = new CreateConnectionMessage();
        create.setTargetID(recover ? (byte)7 : 3);
        create.setConnectionID(this.connectionID);
        create.setFixedClientID(this.fixed);
        create.setClientID(this.clientID);
        create.setRecovered(recover);
        create.setUserName(this.userName);
        create.setPassword(this.password);
        return create;
    }

    private void initialize() {
        this.pool = this.entry.getPooledExecutor();
        this.executor = new SerialExecutor(this.pool);
        this.execution = new SerialExecution();
        this.sequence = BoundedInteger.getIncrementor();
        this.sessions = new Hashtable(3);
        this.consumers = new Hashtable(3);
        this.temporaries = new Hashtable(3);
        this.closed = new SynchronizedBoolean(false);
        this.closePrepared = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.registable = true;
        this.connectionName = this.entry.getName() + "." + this.getConnectionName();
    }

    public AdminMessage sendAdminMessage(AdminMessage adminMessage) throws JMSException {
        this.checkPublic(adminMessage.getOperationID());
        adminMessage.setTargetID((byte)7);
        return this.sendAndWaitReply(adminMessage);
    }

    public AdminMessage sendAdminMessage(byte opcode) throws JMSException {
        this.checkPublic(opcode);
        AdminMessage adminMessage = this.createAdminMessage(opcode);
        return this.sendAndWaitReply(adminMessage);
    }

    private void checkPublic(byte opcode) throws JMSException {
        if (opcode >= 0) {
            throw new JMSException("'" + AdminMessage.getAdminMessageName(opcode) + "' is not a pblic admin message opcode.");
        }
    }

    protected String getConnectionName() {
        return "C" + this.connectionID + (this.clientID == null ? "" : "(" + this.clientID + ")");
    }

    public void recoverFacility() throws JMSException {
        this.recoverConnection();
        this.recoverAttendents();
        if (this.started.get()) {
            this.startConnection();
            this.startAttendents();
        }
    }

    private void recoverConnection() throws JMSException {
        CreateConnectionMessage message = this.createConnectionMessage(true);
        this.recover(message);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2551_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2551_LEVEL, JeusMessage_JMS2._2551, this);
        }
    }

    private void recoverAttendents() throws JMSException {
        int i;
        ClientFacility[] facilities = this.sessions.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            facilities[i].recoverFacility();
        }
        facilities = this.consumers.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            facilities[i].recoverFacility();
        }
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2552_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2552_LEVEL, JeusMessage_JMS2._2552, packet);
        }
        if (packet.isAdminMessage()) {
            throw new JMSException("not supported admin message " + packet);
        }
        ClientMessage message = (ClientMessage)packet;
        message.prepareMessage();
        this.executor.execute(this.execution, message);
    }

    public void handleException(MessageContainer packet, JMSException ex) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2553_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2553_LEVEL, JeusMessage_JMS2._2553, packet, (Throwable)ex);
        }
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.startFacility();
    }

    public void startFacility() throws JMSException {
        if (!this.started.commit(false, true)) {
            return;
        }
        this.execution.setSuspend(false);
        try {
            this.startConnection();
            this.startAttendents();
        }
        catch (JMSException e) {
            this.execution.setSuspend(true);
            this.started.set(false);
            throw e;
        }
    }

    private void startConnection() throws JMSException {
        this.fixClientID();
        AdminMessage start = this.createAdminMessage((byte)4);
        this.sendNotifyMessage(start);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2554_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2554_LEVEL, JeusMessage_JMS2._2554, this);
        }
    }

    private void startAttendents() {
        for (ClientFacility session : this.sessions.values()) {
            try {
                session.startFacility();
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2555_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2555_LEVEL, JeusMessage_JMS2._2555, e);
            }
        }
        for (ClientFacility consumer : this.consumers.values()) {
            try {
                consumer.startFacility();
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2556_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2556_LEVEL, JeusMessage_JMS2._2556, e);
            }
        }
    }

    public void stop() throws JMSException {
        this.checkClosed();
        this.stopFacility();
        if (JMSProperties.CLOSE_CONSUMER_WHEN_CONNECTION_STOP) {
            this.stopAttendents();
        }
    }

    public void stopFacility() throws JMSException {
        if (!this.started.get()) {
            return;
        }
        this.fixClientID();
        this.sendStopMessage();
        this.started.commit(true, false);
    }

    private void stopAttendents() {
        for (ClientFacility session : this.sessions.values()) {
            try {
                session.stopFacility();
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2557_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2557_LEVEL, JeusMessage_JMS2._2557, e);
            }
        }
        for (ClientFacility consumer : this.consumers.values()) {
            try {
                consumer.stopFacility();
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2558_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2558_LEVEL, JeusMessage_JMS2._2558, e);
            }
        }
    }

    public void closeFacility() throws JMSException {
        if (this.closed.get()) {
            return;
        }
        this.prepareShutdown();
        this.shutdown();
    }

    public void close() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2559_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2559_LEVEL, JeusMessage_JMS2._2559, this);
        }
        if (this.entry.tryToConnect()) {
            this.entry.cancelConnect();
        } else {
            this.closeFacility();
        }
    }

    public void prepareShutdown() throws JMSException {
        if (this.closePrepared.get()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2560_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2560_LEVEL, JeusMessage_JMS2._2560, this);
        }
        this.stopFacility();
        this.closeAttendents();
        this.closePrepared.commit(false, true);
    }

    public void shutdown() {
        if (this.closed.get() || !this.closePrepared.get()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2561_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2561_LEVEL, JeusMessage_JMS2._2561, this);
        }
        if (this.sessions.isEmpty() && this.consumers.isEmpty()) {
            this.sendCloseMessage();
            this.entry.unregisterConnection(this.connectionID);
            this.closed.commit(false, true);
            this.entry.shutdownEmpty();
        } else if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2562_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2562_LEVEL, JeusMessage_JMS2._2562, new Object[]{this, this.sessions});
        }
    }

    private void sendStopMessage() throws JMSException {
        AdminMessage stop = this.createAdminMessage((byte)5);
        boolean closed = this.isClosed();
        stop.setBooleanFlag(closed);
        if (closed) {
            JMSSyncRequest request = this.sendSyncRequest(stop);
            request.waitReply(JMSServerEntry.ADMIN_MESSAGE_TIMEOUT);
        } else {
            this.sendNotifyMessage(stop);
        }
    }

    private void sendCloseMessage() {
        AdminMessage close = this.createAdminMessage((byte)6);
        this.sendAndWaitWhile(close);
    }

    protected void closeAttendents() {
        int i;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2563_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2563_LEVEL, JeusMessage_JMS2._2563, new Object[]{this, this.sessions, this.consumers});
        }
        ClientFacility[] facilities = this.sessions.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            try {
                facilities[i].closeFacility();
                continue;
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2564_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2564_LEVEL, JeusMessage_JMS2._2564, e);
            }
        }
        facilities = this.consumers.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            try {
                facilities[i].closeFacility();
                continue;
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2565_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS2._2565_LEVEL, JeusMessage_JMS2._2565, e);
            }
        }
    }

    public void consumerClosed(TemporaryDestination dest, JeusLocalMessageConsumer consumer) {
        TemporaryDestinationManager manager = this.findTemporaryDestinationManager(dest);
        if (manager != null) {
            manager.removeConsumer(consumer);
        }
    }

    public SessionFacility getSessionFacility(int sessionID) throws JMSException {
        SessionFacility facility = (SessionFacility)this.sessions.get(new Integer(sessionID));
        if (facility == null) {
            throw new JMSException("invalid session id " + sessionID);
        }
        return facility;
    }

    public ConnectionConsumerFacility getConnectionConsumerFacility(int consumerID) throws JMSException {
        ConnectionConsumerFacility facility = (ConnectionConsumerFacility)this.consumers.get(new Integer(consumerID));
        if (facility == null) {
            throw new JMSException("invalid connection consumer id " + consumerID);
        }
        return facility;
    }

    public void registerSession(int sessionID, Session session) {
        this.sessions.put(new Integer(sessionID), session);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2566_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2566_LEVEL, JeusMessage_JMS2._2566, new Object[]{session, this});
        }
    }

    public void unregisterSession(int sessionID) {
        Object session = this.sessions.remove(new Integer(sessionID));
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2567_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2567_LEVEL, JeusMessage_JMS2._2567, new Object[]{session, this});
        }
    }

    public void workStarted(Session session) {
    }

    public void workCompleted(Session session) {
    }

    public boolean isSameRM(JeusConnection connection) {
        return this.entry.isSameEntry(connection.entry);
    }

    public void sendBackMessage(ClientMessage message) throws JMSException {
        this.entry.sendBackMessage(message);
    }

    public JeusTemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        String localName = "JEUS_TEMPORARY_QUEUE" + this.getSequenceNumber();
        JeusTemporaryQueue queue = new JeusTemporaryQueue(this.getLocalBrokerName(), localName, this);
        TemporaryQueueManager manager = new TemporaryQueueManager(queue);
        this.temporaries.put(queue, manager);
        return queue;
    }

    public JeusTemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        String localName = "JEUS_TEMPORARY_TOPIC" + this.getSequenceNumber();
        JeusTemporaryTopic topic = new JeusTemporaryTopic(this.getLocalBrokerName(), localName, this);
        TemporaryTopicManager manager = new TemporaryTopicManager(topic);
        this.temporaries.put(topic, manager);
        return topic;
    }

    public TemporaryDestinationManager findTemporaryDestinationManager(DestinationIdentity dest) {
        return (TemporaryDestinationManager)this.temporaries.get(dest);
    }

    public TemporaryDestinationManager getTemporaryDestinationManager(DestinationIdentity dest) throws InvalidDestinationException {
        TemporaryDestinationManager manager = this.findTemporaryDestinationManager(dest);
        if (manager == null) {
            throw new InvalidDestinationException("invalid destination manager " + dest);
        }
        return manager;
    }

    public void removeTemporaryDestination(TemporaryDestination dest) throws JMSException {
        this.checkClosed();
        TemporaryDestinationManager manager = this.getTemporaryDestinationManager(dest);
        if (manager.consumerAttatched()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3133, dest.getLocalName());
        }
        this.temporaries.remove(dest);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        ackMode = !transacted && ackMode == 0 ? 1 : ackMode;
        return this.createSession(transacted, ackMode, this.type);
    }

    public Session createSession(boolean transacted, int ackMode, int type) throws JMSException {
        this.checkClosed();
        ackMode = this.checkInvalidAcknowlegeMode(transacted, ackMode);
        JeusSession session = new JeusSession((Connection)this, ackMode, type);
        session.createFacility();
        this.fixClientID();
        return session;
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        this.confirmQueue();
        return (QueueSession)this.createSession(transacted, ackMode, 81);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        this.confirmTopic();
        return (TopicSession)this.createSession(transacted, ackMode, 84);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        JeusConnectionConsumer consumer = new JeusConnectionConsumer(this, destination, selector, sessionPool, maxMessages);
        consumer.createFacility();
        this.fixClientID();
        return consumer;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.confirmQueue();
        return this.createConnectionConsumer((Destination)queue, selector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.confirmTopic();
        return this.createConnectionConsumer((Destination)topic, selector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String durableName, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.confirmTopic();
        this.checkArgument(topic, sessionPool, durableName);
        this.checkClosed();
        DurableConnectionConsumer consumer = new DurableConnectionConsumer(this, topic, durableName, selector, sessionPool, maxMessages);
        consumer.createFacility();
        this.fixClientID();
        return consumer;
    }

    private void checkArgument(Topic topic, ServerSessionPool sessionPool, String subscriptionName) throws JMSException {
        if (topic == null || sessionPool == null || subscriptionName == null) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4206);
        }
    }

    public void sendNotifyMessage(MessageContainer packet) throws JMSException {
        packet.setConnectionID(this.connectionID);
        this.entry.sendNotifyMessage(packet);
    }

    public void sendAndWaitWhile(MessageContainer packet) {
        block2: {
            try {
                this.sendAndWaitReply(packet, JMSServerEntry.ADMIN_MESSAGE_TIMEOUT);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2568_LEVEL)) break block2;
                LogUtils.log(logger, JeusMessage_JMS2._2568_LEVEL, JeusMessage_JMS2._2568, e);
            }
        }
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet) throws JMSException {
        return this.sendAndWaitReply(packet, JMSServerEntry.ADMIN_MESSAGE_TIMEOUT << 2);
    }

    public AdminMessage recover(MessageContainer packet) throws JMSException {
        return this.recover(packet, JMSServerEntry.ADMIN_MESSAGE_TIMEOUT << 2);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet, long timeout) throws JMSException {
        packet.setConnectionID(this.connectionID);
        AdminMessage message = (AdminMessage)this.entry.sendAndWaitSyncRequest(packet, timeout);
        if (message.getException() != null) {
            throw message.getException();
        }
        return message;
    }

    public AdminMessage recover(MessageContainer packet, long timeout) throws JMSException {
        packet.setConnectionID(this.connectionID);
        AdminMessage message = (AdminMessage)this.entry.recover(packet, timeout);
        if (message.getException() != null) {
            throw message.getException();
        }
        return message;
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) throws JMSException {
        packet.setConnectionID(this.connectionID);
        return this.entry.sendSyncRequest(packet);
    }

    public void cancelSyncRequest(JMSSyncRequest request) {
        this.entry.cancelMessageRequest(request);
    }

    public void sendReply(MessageContainer packet) throws JMSException {
        packet.setConnectionID(this.connectionID);
        this.entry.sendReplyMessage(packet);
    }

    public void addConsumer(int consumerID, ConsumerFacility consumer) {
        this.consumers.put(new Integer(consumerID), consumer);
    }

    public void removeConsumer(int consumerID) {
        this.consumers.remove(new Integer(consumerID));
    }

    public MessageID getNextMessageID() {
        int sequence = this.getSequenceNumber();
        return new MessageID(this.entry.getBrokerID(), this.entry.getId(), this.connectionID, sequence);
    }

    public int getSequenceNumber() {
        return this.sequence.getNextValue();
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    public void setClientID(String newClientID) throws JMSException {
        this.checkClosed();
        if (this.clientID != null && this.clientID.equals(newClientID)) {
            return;
        }
        if (!this.registable) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4204, 1);
        }
        SetClientIDMessage message = new SetClientIDMessage(newClientID);
        this.sendAndWaitReply(message);
        this.clientID = newClientID;
        this.connectionName = this.entry.getName() + "." + this.getConnectionName();
        this.fixClientID();
    }

    public void fixClientID() {
        this.registable = false;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        this.fixClientID();
        return new JeusConnectionMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        this.fixClientID();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        if (listener == null) {
            throw new JMSException("invalid exception listener " + listener);
        }
        this.fixClientID();
        this.exceptionListener = listener;
    }

    public boolean exceptionOccurred(MessageHandler from, JMSException ex) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(ex);
            return true;
        }
        return false;
    }

    private void confirmQueue() throws IllegalStateException {
        if (this.type == 84) {
            throw new IllegalStateException("this connection is dedicated to queue type messaging");
        }
    }

    private void confirmTopic() throws IllegalStateException {
        if (this.type == 81) {
            throw new IllegalStateException("this connection is dedicated to topic type messaging");
        }
    }

    private AdminMessage createAdminMessage(byte opcode) {
        AdminMessage admin = MessageUtil.createAdminMessage(opcode);
        admin.setTargetID((byte)7);
        return admin;
    }

    void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4272, 1);
        }
    }

    private int checkInvalidAcknowlegeMode(boolean transacted, int ackMode) throws JMSException {
        int n = transacted ? 0 : (ackMode = JMSServerEntry.RI_COMPATIBLE && ackMode == 0 ? 1 : ackMode);
        if (!transacted && ackMode != 1 && ackMode != 2 && ackMode != 3 && ackMode != -1) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3126, String.valueOf(ackMode));
        }
        return ackMode;
    }

    public SerialExecutor getClientExecutor() {
        return this.executor;
    }

    public long getEntryID() {
        return this.entry.getId();
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public String getFacilityName() {
        return this.connectionName;
    }

    public String getLocalBrokerName() {
        return this.entry.getBrokerName();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosePrepared() {
        return this.closePrepared.get();
    }

    public boolean isAllClosed() {
        return this.closed.get() && this.sessions.isEmpty() && this.consumers.isEmpty();
    }

    public void flushWorks() {
        this.entry.flushWorks();
    }

    public void freeze(Freezer freezer) {
        int i;
        ClientFacility[] facilities = this.sessions.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            facilities[i].freeze(freezer);
        }
        facilities = this.consumers.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            facilities[i].freeze(freezer);
        }
    }

    public void thaw(Freezer freezer) {
        int i;
        ClientFacility[] facilities = this.sessions.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            facilities[i].thaw(freezer);
        }
        facilities = this.consumers.values().toArray(new ClientFacility[0]);
        for (i = 0; i < facilities.length; ++i) {
            facilities[i].thaw(freezer);
        }
    }

    public String toString() {
        return this.connectionName;
    }

    public boolean isForcedReconnect() {
        return false;
    }

    protected final JeusConnectionConsumer[] getConnectionConsumers() {
        return this.consumers.values().toArray(new JeusConnectionConsumer[0]);
    }

    private class SerialExecution
    extends ClientSerialExecutable {
        private SerialExecution() {
        }

        public boolean execute(ClientMessage message) throws Exception {
            TemporaryDestinationManager manager = JeusConnection.this.getTemporaryDestinationManager(message.getDestination());
            manager.produce(message);
            return true;
        }

        public void success(ClientMessage message) throws JMSException {
            MessageHandleEvent event = MessageUtil.createEventMessage((byte)50, message.getMessageID());
            event.setObserverID(message.getObserverID());
            JeusConnection.this.sendReply(event);
        }

        public void exception(ClientMessage message, JMSException ex) {
            block2: {
                MessageHandleEvent event = MessageUtil.createEventMessage((byte)51, message);
                event.setException(ex);
                try {
                    JeusConnection.this.sendReply(event);
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2569_LEVEL)) break block2;
                    LogUtils.log(logger, JeusMessage_JMS2._2569_LEVEL, JeusMessage_JMS2._2569, (Object)ex, (Throwable)e);
                }
            }
        }
    }
}

