/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.connection;

import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.client.facility.session.JeusXASession;
import jeus.jms.client.facility.session.SessionFacility;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public class JeusXAConnection
extends JeusConnection
implements XAQueueConnection,
XATopicConnection {
    public JeusXAConnection(JMSServerEntry entry, String clientID, boolean fixed, int type) {
        super(entry, clientID, fixed, type);
    }

    public JeusXAConnection(JMSServerEntry entry, String clientID, boolean fixed) {
        super(entry, clientID, fixed);
    }

    public boolean isForcedReconnect() {
        SessionFacility[] facilities = this.sessions.values().toArray(new SessionFacility[0]);
        for (int i = 0; i < facilities.length; ++i) {
            SessionFacility facility = facilities[i];
            if (!(facility instanceof JeusXASession) || !((JeusXASession)facility).isXAParticipant() || ((JeusXASession)facility).isXAEnlisted()) continue;
            return true;
        }
        return false;
    }

    protected String getConnectionName() {
        return "X" + super.getConnectionName();
    }

    public void registerSession(int sessionID, XASession session) {
        super.registerSession(sessionID, (Session)session);
    }

    public void unregisterSession(int sessionID) {
        super.unregisterSession(sessionID);
    }

    public void workStarted(XASession session) {
    }

    public void workCompleted(XASession session) {
    }

    private boolean isCtsCompatible(boolean transacted, int ackMode) {
        boolean compatible;
        boolean bl = compatible = JMSServerEntry.RI_COMPATIBLE && (TransactionProvider.isXATransacted() || ackMode == 0);
        if (compatible && logger.isLoggable(Level.FINEST) && LogUtils.isLoggable(logger, JeusMessage_JMS2._2521_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2521_LEVEL, JeusMessage_JMS2._2521);
        }
        return compatible;
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        if (this.isCtsCompatible(transacted, ackMode)) {
            return (QueueSession)this.createXASession();
        }
        return super.createQueueSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        if (this.isCtsCompatible(transacted, ackMode)) {
            return (TopicSession)this.createXASession();
        }
        return super.createTopicSession(transacted, ackMode);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        if (this.isCtsCompatible(transacted, ackMode)) {
            return this.createXASession();
        }
        return super.createSession(transacted, ackMode);
    }

    public XASession createXASession() throws JMSException {
        this.checkClosed();
        JeusXASession session = new JeusXASession(this, this.type);
        session.createFacility();
        this.fixClientID();
        return session;
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        return (XAQueueSession)this.createXASession();
    }

    public XATopicSession createXATopicSession() throws JMSException {
        return (XATopicSession)this.createXASession();
    }
}

