/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.consumer;

import java.util.Hashtable;
import java.util.List;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.client.facility.consumer.ClientMessageQueue;
import jeus.jms.client.facility.consumer.ConnectionConsumerFacility;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.client.facility.session.SessionFacility;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateConsumerMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.jms.common.util.SerialExecutor;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Journal;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public class JeusConnectionConsumer
extends ClientMessageQueue
implements ConnectionConsumerFacility {
    private SynchronizedBoolean closed;
    private SynchronizedBoolean stop;
    private ServerSession server;
    private JeusSession session;
    private Hashtable sessionList;
    private JeusConnection connection;
    private int consumerID;
    private DestinationIdentity destination;
    private String consumerName;
    private String selector;
    private int maxMessages;
    private SerialExecutor executor;
    private ServerSessionPool sessionPool;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JeusConnectionConsumer(JeusConnection connection, Destination destination, String selector, ServerSessionPool sessionPool, int maxMessages) {
        this.destination = (DestinationIdentity)destination;
        this.selector = this.trimSelector(selector);
        this.connection = connection;
        this.sessionPool = sessionPool;
        this.maxMessages = maxMessages;
        this.initialize();
    }

    void initialize() {
        this.executor = this.connection.getClientExecutor();
        this.sessionList = new Hashtable();
        this.closed = new SynchronizedBoolean(false);
        this.stop = new SynchronizedBoolean(false);
    }

    public void createFacility() throws JMSException {
        if (this.destination.isTemporary()) {
            this.consumerName = this.connection.getFacilityName() + ".CC" + this.destination;
        } else {
            CreateConsumerMessage message = this.getCreateConsumerMessage(false);
            AdminMessage reply = this.sendAndWaitReply(message);
            this.consumerID = reply.getConsumerID();
            this.consumerName = this.connection.getFacilityName() + ".CC" + this.consumerID;
            this.connection.addConsumer(this.consumerID, this);
            if (this.connection.isStarted()) {
                this.startReceive();
            }
        }
    }

    public AdminMessage sendAdminMessage(AdminMessage adminMessage) throws JMSException {
        this.checkPublic(adminMessage.getOperationID());
        adminMessage.setTargetID((byte)23);
        return this.sendAndWaitReply(adminMessage);
    }

    public AdminMessage sendAdminMessage(byte opcode) throws JMSException {
        this.checkPublic(opcode);
        return this.sendAndWaitReply(this.createAdminMessage(opcode));
    }

    private void checkPublic(byte opcode) throws JMSException {
        if (opcode >= 0) {
            throw new JMSException("'" + AdminMessage.getAdminMessageName(opcode) + "' is not a pblic admin message opcode.");
        }
    }

    public void recoverFacility() throws JMSException {
        CreateConsumerMessage message = this.getCreateConsumerMessage(true);
        this.connection.recover(message);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2241_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2241_LEVEL, JeusMessage_JMS2._2241, this);
        }
    }

    CreateConsumerMessage getCreateConsumerMessage(boolean recover) {
        CreateConsumerMessage message = new CreateConsumerMessage(this.destination.getLocalName());
        message.setTargetID(recover ? (byte)23 : 7);
        message.setBooleanFlag(this.connection.isStarted());
        message.setSelector(this.selector);
        message.setRecovered(recover);
        return message;
    }

    public void handleMessage(MessageContainer packet) {
        if (packet.isAdminMessage()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2242_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2242_LEVEL, JeusMessage_JMS2._2242, new Object[]{packet, this});
        }
        ClientMessage message = (ClientMessage)packet;
        message.prepareMessage();
        this.enqueueWork(message);
    }

    public void handleException(MessageContainer packet, JMSException ex) {
    }

    public void startFacility() throws JMSException {
        AdminMessage start = this.createAdminMessage((byte)4);
        this.sendNotifyMessage(start);
        this.startReceive();
    }

    private void startReceive() throws JMSException {
        this.setSuspend(false);
        try {
            this.setAsyncDelivery(true);
        }
        catch (JMSException e) {
            this.setSuspend(true);
            throw e;
        }
        this.startExecution();
    }

    public void stopFacility() throws JMSException {
        if (this.stop.commit(false, this.isClosed())) {
            this.setSuspend(true);
            this.sendStopMessage();
        }
    }

    public void closeFacility() throws JMSException {
        this.close();
    }

    public void close() throws JMSException {
        if (!this.closed.commit(false, true)) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2243_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2243_LEVEL, JeusMessage_JMS2._2243, this);
        }
        this.stopFacility();
        this.shutdownExecutor();
        if (this.sessionList.isEmpty()) {
            this.shutdown();
        } else {
            this.addShutdownWork();
        }
    }

    private void shutdown() throws JMSException {
        this.sendCloseMessage();
        this.connection.removeConsumer(this.consumerID);
    }

    public ServerSessionPool getServerSessionPool() {
        return this.sessionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addShutdownWork() {
        Hashtable hashtable = this.sessionList;
        synchronized (hashtable) {
            ShutdownWork work = new ShutdownWork();
            for (SessionFacility session : this.sessionList.values()) {
                session.addFinishWork(work);
            }
        }
    }

    private void sendStopMessage() throws JMSException {
        AdminMessage stop = this.createAdminMessage((byte)5);
        stop.setBooleanFlag(this.isClosed());
        if (this.isClosed()) {
            this.sendAndWaitWhile(stop);
        } else {
            this.sendNotifyMessage(stop);
        }
    }

    void sendCloseMessage() throws JMSException {
        AdminMessage close = this.createAdminMessage((byte)6);
        JMSSyncRequest request = this.sendSyncRequest(close);
        request.waitReply(JMSServerEntry.ADMIN_MESSAGE_TIMEOUT);
    }

    public MessageHandleEvent createMessageEvent(byte opcode, ClientMessage message) {
        MessageHandleEvent event = MessageUtil.createEventMessage(opcode, message);
        this.setEventTarget(opcode, event);
        return event;
    }

    public MessageHandleEvent createMessageEvent(byte opcode, List works) {
        MessageHandleEvent event = MessageUtil.createEventMessage(opcode, works);
        this.setEventTarget(opcode, event);
        return event;
    }

    public AdminMessage createAdminMessage(byte opcode) {
        AdminMessage admin = MessageUtil.createAdminMessage(opcode);
        this.setFacilityTarget(admin);
        return admin;
    }

    private void setEventTarget(byte opcode, MessageHandleEvent event) {
        if (opcode == 50) {
            this.setSessionTarget(event);
        } else {
            this.setFacilityTarget(event);
        }
    }

    private void setFacilityTarget(AdminMessage event) {
        event.setTargetID((byte)23);
        event.setConsumerID(this.consumerID);
    }

    private void setSessionTarget(MessageHandleEvent event) {
        event.setTargetID((byte)15);
        event.setConnectionConsumerID(this.consumerID);
    }

    public void sendNotifyMessage(MessageContainer packet) throws JMSException {
        this.connection.sendNotifyMessage(packet);
    }

    public void sendAndWaitWhile(MessageContainer packet) {
        this.connection.sendAndWaitWhile(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet) throws JMSException {
        return this.connection.sendAndWaitReply(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet, long time) throws JMSException {
        return this.connection.sendAndWaitReply(packet, time);
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) throws JMSException {
        return this.connection.sendSyncRequest(packet);
    }

    public void cancelSyncRequest(JMSSyncRequest request) {
        this.connection.cancelSyncRequest(request);
    }

    private String trimSelector(String selector) {
        return selector != null && selector.trim().equals("") ? null : selector;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public boolean isClosed() {
        return this.connection.isClosed() || this.closed.get();
    }

    public void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4271, 1);
        }
    }

    public void registerSession(int sessionID, Session session) {
        this.sessionList.put(new Integer(sessionID), session);
    }

    public void unregisterSession(int sessionID) {
        this.sessionList.remove(new Integer(sessionID));
    }

    public boolean isStarted() {
        return this.connection.isStarted();
    }

    public String getFacilityName() {
        return this.consumerName;
    }

    public Journal getLogger() {
        return logger;
    }

    public String toString() {
        return this.consumerName;
    }

    public void preExecution(ClientMessage message) throws JMSException {
        message.setReturnBack(this.isClosed());
        if (!message.isReturnBack()) {
            this.acquireServerSession();
        }
    }

    public boolean execute(ClientMessage message) throws JMSException {
        if (message.isReturnBack()) {
            this.connection.sendBackMessage(message);
            return false;
        }
        this.session.enqueueAsyncMessages((byte)23, message);
        if (this.isEmpty() || this.session.getEnqueuedWorks() >= this.maxMessages) {
            this.startSession();
        }
        return true;
    }

    public void exception(ClientMessage message, JMSException e) {
        this.recover((MessageEventProvider)this, message);
    }

    private void acquireServerSession() throws JMSException {
        if (this.server == null) {
            this.server = this.sessionPool.getServerSession();
            this.session = this.getExecutableSession();
        }
        this.session.assignConnectionConsumer(this);
    }

    private JeusSession getExecutableSession() throws JMSException {
        if (this.server == null) {
            throw new IllegalStateException("invalid executable session from session pool");
        }
        return (JeusSession)this.server.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSession() throws JMSException {
        try {
            this.server.start();
        }
        finally {
            this.server = null;
        }
    }

    protected void messageAvailable() {
        if (this.connection.isStarted() || this.isClosed()) {
            this.executor.execute(this);
        }
    }

    public void freeze(Freezer freezer) {
    }

    public void thaw(Freezer freezer) {
    }

    private class ShutdownWork
    implements Runnable {
        SynchronizedInt counter;

        public ShutdownWork() {
            this.counter = new SynchronizedInt(JeusConnectionConsumer.this.sessionList.size());
        }

        public void run() {
            if (this.counter.decrement() == 0) {
                block4: {
                    try {
                        JeusConnectionConsumer.this.shutdown();
                    }
                    catch (JMSException e) {
                        if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2244_LEVEL)) break block4;
                        LogUtils.log(logger, JeusMessage_JMS2._2244_LEVEL, JeusMessage_JMS2._2244, JeusConnectionConsumer.this, (Throwable)e);
                    }
                }
                if (JeusConnectionConsumer.this.connection.isAllClosed()) {
                    JeusConnectionConsumer.this.connection.shutdown();
                }
            }
        }

        public String toString() {
            return "SHUTDOWN " + JeusConnectionConsumer.this;
        }
    }
}

