/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.factory;

import java.util.HashSet;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.client.facility.factory.JeusConnectionFactory;
import jeus.jms.client.facility.factory.JeusXAConnectionFactory;
import jeus.jms.client.facility.factory.JeusXARecoveryConnectionFactory;

public class ConnectionFactoryOF
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (!(obj instanceof Reference)) {
            return new JMSException("invalid factory object " + obj + " for name " + name);
        }
        Reference ref = (Reference)obj;
        String factoryName = (String)ref.get("factoryName").getContent();
        int factoryType = (Integer)ref.get("type").getContent();
        int maxThread = (Integer)ref.get("maxThread").getContent();
        HashSet addresses = (HashSet)ref.get("addresses").getContent();
        String policyType = (String)ref.get("brokerSelectionPolicy").getContent();
        String clientID = (String)ref.get("clientID").getContent();
        boolean fixed = (Boolean)ref.get("fixed").getContent();
        boolean ssl = (Boolean)ref.get("sslSupport").getContent();
        boolean xa = (Boolean)ref.get("xaSupport").getContent();
        boolean recovery = (Boolean)ref.get("xaRecovery").getContent();
        if (xa) {
            TransactionProvider provider;
            JeusXARecoveryConnectionFactory recoveryFactory = new JeusXARecoveryConnectionFactory(factoryName, factoryType, addresses, policyType, maxThread, clientID, fixed, ssl, true);
            if (recovery) {
                return recoveryFactory;
            }
            JeusXAConnectionFactory factory = new JeusXAConnectionFactory(factoryName, factoryType, addresses, policyType, maxThread, clientID, fixed, ssl, true);
            if (!factory.hasLocalAddress() && (provider = TransactionProvider.getTransactionProvider()) != null) {
                Reference recoveryRef = recoveryFactory.getReference();
                provider.registerXAConnectionFactory(recoveryRef, factoryName);
            }
            return factory;
        }
        return new JeusConnectionFactory(factoryName, factoryType, addresses, policyType, maxThread, clientID, fixed, ssl, true);
    }
}

