/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.factory;

import java.util.HashSet;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.connection.JeusXAConnection;
import jeus.jms.client.facility.factory.JeusConnectionFactory;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.pool.JeusXAServerSessionPool;
import jeus.jms.common.pool.SessionPoolManager;

public class JeusXAConnectionFactory
extends JeusConnectionFactory
implements XAQueueConnectionFactory,
XATopicConnectionFactory {
    public JeusXAConnectionFactory() {
    }

    public JeusXAConnectionFactory(JMSServiceChannelAddress address) {
        super(address);
    }

    public JeusXAConnectionFactory(String factoryName, JMSServiceChannelAddress address) {
        super(factoryName, address);
    }

    public JeusXAConnectionFactory(String factoryName, int factoryType, HashSet addresses, String policyType, int maxThread, String clientID, boolean fixed, boolean ssl, boolean cluster) {
        super(factoryName, factoryType, addresses, policyType, maxThread, clientID, fixed, ssl, cluster);
        this.xaSupport = true;
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null, this.factoryType);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return this.createXAConnection(userName, password, this.factoryType);
    }

    public XAConnection createXAConnection(String userName, String password, int type) throws JMSException {
        JMSServerEntry entry = this.createJMSServerEntry();
        JeusXAConnection con = new JeusXAConnection(entry, this.clientID, this.fixed, type);
        con.createConnection(userName, password);
        return con;
    }

    public boolean hasLocalAddress() {
        return JMSServiceChannelAddress.hasLocalAddress(this.addresses);
    }

    public ServerSessionPool createXASessionPool(SessionPoolManager manager, String userName, String password, int type) throws JMSException {
        JMSServerEntry entry = this.createJMSServerEntry();
        JeusXAServerSessionPool con = new JeusXAServerSessionPool(entry, manager, this.clientID, this.fixed, type);
        con.createConnection(userName, password);
        return con;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createXAConnection(null, null, 81);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        return (XAQueueConnection)this.createXAConnection(userName, password, 81);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createXAConnection(null, null, 84);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        return (XATopicConnection)this.createXAConnection(userName, password, 84);
    }

    public Connection createConnection() throws JMSException {
        if (JMSServerEntry.RI_COMPATIBLE) {
            return this.createXAConnection();
        }
        return super.createConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (JMSServerEntry.RI_COMPATIBLE) {
            return this.createXAConnection(userName, password);
        }
        return super.createConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (JMSServerEntry.RI_COMPATIBLE) {
            return this.createXAQueueConnection();
        }
        return super.createQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (JMSServerEntry.RI_COMPATIBLE) {
            return this.createXAQueueConnection(userName, password);
        }
        return super.createQueueConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (JMSServerEntry.RI_COMPATIBLE) {
            return this.createXATopicConnection();
        }
        return super.createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (JMSServerEntry.RI_COMPATIBLE) {
            return this.createXATopicConnection(userName, password);
        }
        return super.createTopicConnection(userName, password);
    }

    public String toString() {
        return "XACF(" + this.factoryType + ")" + this.factoryDesc;
    }
}

