/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.session;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TransactionRolledBackException;
import javax.transaction.xa.XAException;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.ClientFacility;
import jeus.jms.client.facility.consumer.ConnectionConsumerFacility;
import jeus.jms.client.facility.consumer.JeusConnectionConsumer;
import jeus.jms.client.facility.session.AbstractSession;
import jeus.jms.client.util.ClientSerialExecutable;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateSessionMessage;
import jeus.jms.common.util.AcknowledgeManager;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.jms.common.util.SerialExecutor;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public class JeusSession
extends AbstractSession {
    private ConnectionConsumerFacility consumer;
    private Dispatcher dispatcher;
    private SerialExecutor executor;
    private AsyncMessageQueue asyncQueue;
    private AcknowledgeManager ackManager;
    private TransactedMessageQueue txMsgQueue;
    private boolean rollbackOnly;
    private MessageListener listener;
    private SynchronizedBoolean closed;

    public JeusSession(Connection connection, int ackMode, int type) {
        super(connection, ackMode, type);
        this.initialize();
    }

    void initialize() {
        super.initialize();
        this.executor = this.connection.getClientExecutor();
        this.asyncQueue = new AsyncMessageQueue();
        this.txMsgQueue = new TransactedMessageQueue();
        this.dispatcher = new Dispatcher();
        this.closed = new SynchronizedBoolean(false);
        this.txMsgQueue.setSuspend(false);
    }

    public void createFacility() throws JMSException {
        AdminMessage create = this.getCreateSessionMessage(false);
        try {
            create = this.sendAndWaitReply(create);
            this.sessionID = create.getSessionID();
            this.setFacilityName();
            this.registerSession();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4201, null, ex);
        }
        if (this.connection.isStarted()) {
            this.startFacility();
        }
        this.enlistGlobalTransaction();
    }

    void setFacilityName() {
        this.sessionName = this.connection.getFacilityName() + ".S" + this.sessionID;
    }

    public void recoverFacility() throws JMSException {
        this.recoverSession();
        this.recoverAttendents();
    }

    AdminMessage getCreateSessionMessage(boolean recover) {
        CreateSessionMessage create = new CreateSessionMessage(this.ackMode);
        create.setTargetID(recover ? (byte)15 : 7);
        create.setRecovered(recover);
        return create;
    }

    void recoverSession() throws JMSException {
        AdminMessage create = this.getCreateSessionMessage(true);
        this.recover(create);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2321_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2321_LEVEL, JeusMessage_JMS2._2321, this);
        }
    }

    void registerSession() {
        this.connection.registerSession(this.sessionID, this);
    }

    public void handleMessage(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2322_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2322_LEVEL, JeusMessage_JMS2._2322, new Object[]{packet, this});
        }
        if (packet.isAdminMessage()) {
            this.handlAdminMessage((AdminMessage)packet);
        } else {
            this.executor.execute(this.dispatcher, (ClientMessage)packet);
        }
    }

    public void handleException(MessageContainer packet, JMSException ex) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2323_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2323_LEVEL, JeusMessage_JMS2._2323, packet, (Throwable)ex);
        }
    }

    private void sendBackMessage(ClientMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2324_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2324_LEVEL, JeusMessage_JMS2._2324, message);
        }
        this.connection.sendBackMessage(message);
    }

    private void handlAdminMessage(AdminMessage message) {
        switch (message.getLocalTargetID()) {
            case 15: 
            case 31: 
            case 47: {
                JMSException ex = message.getException();
                if (ex == null) break;
                this.connection.exceptionOccurred(this, ex);
                this.rollbackOnly = this.rollbackOnly || this.isTransactionParticipant();
            }
        }
    }

    public boolean asyncConsumeMessage(ClientMessage message) throws Exception {
        if (this.isClosed()) {
            try {
                this.sendBackMessage(message);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            return false;
        }
        this.enlistGlobalTransaction();
        int ackmode = this.getAcknowledgeMode();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2325_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2325_LEVEL, JeusMessage_JMS2._2325, new Object[]{message, new Integer(ackmode)});
        }
        message.consuming(ackmode);
        try {
            message.onMessage();
            message.consumed(ackmode);
        }
        catch (RuntimeException re) {
            try {
                message.runtimeException(ackmode, re);
            }
            catch (JMSException jmxEx) {
                jmxEx.setLinkedException((Exception)re);
                throw jmxEx;
            }
            throw re;
        }
        return true;
    }

    void sessionEngaged() {
        this.enlistConnectionConsumer();
        this.connection.workStarted(this);
    }

    void sessionReleased() {
        this.delistConnectionConsumer();
        this.connection.workCompleted(this);
    }

    void enlistConnectionConsumer() {
        if (this.consumer != null) {
            this.consumer.registerSession(this.sessionID, this);
        }
    }

    void delistConnectionConsumer() {
        if (this.consumer != null) {
            this.consumer.unregisterSession(this.sessionID);
        }
    }

    public void recover() throws JMSException {
        this.checkClosed();
        if (this.isTransactionParticipant()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3104, 1);
        }
        this.recoverAll();
    }

    public void commit() throws JMSException {
        this.commit(false);
    }

    public void commit(boolean rollback) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2326_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2326_LEVEL, JeusMessage_JMS2._2326, new Object[]{this.txMsgQueue, this});
        }
        this.checkClosed();
        this.checkTransactionStatus();
        this.checkRollbackOnly();
        this.acknowledgeAll();
        this.flushTransacted();
        try {
            this.sendTransactionDecision((byte)81, rollback);
            this.afterCompletion(3);
        }
        catch (TransactionRolledBackException e) {
            this.recoverAll();
            this.afterCompletion(4);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2327_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2327_LEVEL, JeusMessage_JMS2._2327, new Object[]{this.txMsgQueue, this});
        }
        this.checkClosed();
        this.checkTransactionStatus();
        this.clearTransacted();
        this.recoverAll();
        try {
            this.sendTransactionDecision((byte)82, false);
        }
        finally {
            this.afterCompletion(4);
        }
    }

    private void checkRollbackOnly() throws JMSException {
        if (this.rollbackOnly) {
            this.rollback();
            throw new TransactionRolledBackException("transaction is marked rollback only");
        }
    }

    public void checkXATransaction() throws XAException {
        if (this.rollbackOnly) {
            throw new XAException(-6);
        }
    }

    public void flushTransaction() throws JMSException {
        this.flushTransacted();
        this.acknowledgeAll();
    }

    public void clearTransaction() throws JMSException {
        this.clearTransacted();
        this.recoverAll();
    }

    public void afterCompletion(int status) {
        this.rollbackOnly = false;
        this.clearAll();
        this.doFinishWorks();
    }

    public void flushTransacted() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2328_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2328_LEVEL, JeusMessage_JMS2._2328, new Object[]{this.txMsgQueue, this});
        }
        this.txMsgQueue.startExecution();
    }

    public void clearTransacted() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2329_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2329_LEVEL, JeusMessage_JMS2._2329, new Object[]{this.txMsgQueue, this});
        }
        this.txMsgQueue.clearWorks();
    }

    public void startFacility() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2330_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2330_LEVEL, JeusMessage_JMS2._2330, new Object[]{this, this.txMsgQueue});
        }
        this.enlistGlobalTransaction();
        this.dispatcher.setSuspend(false);
        this.asyncQueue.setSuspend(false);
        this.sendStartMessage();
        this.startAttendents();
    }

    public void stopFacility() throws JMSException {
        if (JMSProperties.CLOSE_CONSUMER_WHEN_CONNECTION_STOP) {
            ClientFacility[] consumers = this.consumerList.values().toArray(new ClientFacility[0]);
            for (int i = 0; i < consumers.length; ++i) {
                try {
                    consumers[i].closeFacility();
                    continue;
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2331_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2331_LEVEL, JeusMessage_JMS2._2331, new Object[]{this, this.txMsgQueue});
            }
            this.sendStopMessage();
            this.stopAttendents();
        }
    }

    public void closeFacility() throws JMSException {
        this.close();
    }

    public void close() throws JMSException {
        if (this.closed.get()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2332_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2332_LEVEL, JeusMessage_JMS2._2332, this);
        }
        this.stopFacility();
        this.closeAttendents();
        this.shutdown();
    }

    public boolean hasPendingWorks() {
        return !this.asyncQueue.isEmpty() || super.hasPendingWorks();
    }

    void prepareClose() {
        if (this.ackMode == 0 || this.ackMode == 2) {
            this.clearTransacted();
            try {
                this.recoverAll();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.doFinishWorks();
        }
        this.closed.commit(false, true);
    }

    private void sendStartMessage() throws JMSException {
        AdminMessage stop = this.createAdminMessage((byte)4);
        this.sendNotifyMessage(stop);
    }

    private void sendStopMessage() throws JMSException {
        AdminMessage stop = this.createAdminMessage((byte)5);
        stop.setBooleanFlag(this.isClosed());
        if (this.isClosed()) {
            this.sendAndWaitWhile(stop);
        } else {
            this.sendNotifyMessage(stop);
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2333_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2333_LEVEL, JeusMessage_JMS2._2333, new Object[]{this, this.listener});
        }
        this.checkClosed();
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2334_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2334_LEVEL, JeusMessage_JMS2._2334, new Object[]{this, listener});
        }
        this.checkClosed();
        this.listener = listener;
    }

    public void producedMessage(ClientMessage message) throws JMSException {
        this.setMessageID(message);
        this.enlistGlobalTransaction();
        if (this.isTransacted()) {
            this.enqueueMessage(message);
        } else {
            boolean sync;
            if (message.getMessageType() == 70) {
                sync = true;
            } else if (this.ackMode == -1 || JMSProperties.OPTIMIZED_PRODUCE) {
                sync = false;
                message.setDirect(true);
            } else {
                sync = true;
            }
            this.sendMessage(message, sync);
        }
    }

    private void setMessageID(ClientMessage message) {
        MessageID messageID = this.connection.getNextMessageID();
        message.setJMSMessageID(messageID.getJMSMessageID());
        message.setMessageID(messageID);
    }

    private void enqueueMessage(ClientMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2335_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2335_LEVEL, JeusMessage_JMS2._2335, new Object[]{message, this.txMsgQueue, this});
        }
        message = (ClientMessage)message.clone();
        this.txMsgQueue.enqueueWork(message);
    }

    boolean isServerSession() {
        return this.listener != null;
    }

    public int getEnqueuedWorks() {
        return this.asyncQueue.size();
    }

    public void enqueueAsyncMessages(byte type, ClientMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2336_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2336_LEVEL, JeusMessage_JMS2._2336, new Object[]{message, this.asyncQueue, this});
        }
        if (type == 23) {
            message.setMessageListener(this.listener);
            message.setExecutionContext(this.ackManager);
        }
        this.asyncQueue.enqueueWork(message);
    }

    public void run() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2337_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2337_LEVEL, JeusMessage_JMS2._2337, new Object[]{this, new Integer(this.asyncQueue.queuedWorks())});
        }
        this.asyncQueue.startExecution();
    }

    private void sendMessage(ClientMessage message, boolean sync) throws JMSException {
        message.setSessionID(this.sessionID);
        if (sync) {
            AdminMessage reply = this.sendAndWaitReply(message);
            message.setJMSDeliveryMode(reply.getBooleanFlag() ? 2 : 1);
        } else {
            this.sendNotifyMessage(message);
        }
    }

    public void recover(AdminMessage packet) throws JMSException {
        packet.setSessionID(this.sessionID);
        this.connection.recover(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet) throws JMSException {
        packet.setSessionID(this.sessionID);
        return this.connection.sendAndWaitReply(packet);
    }

    public void sendAndWaitWhile(MessageContainer packet) {
        packet.setSessionID(this.sessionID);
        this.connection.sendAndWaitWhile(packet);
    }

    public AdminMessage sendAndWaitReply(MessageContainer packet, long timeout) throws JMSException {
        packet.setSessionID(this.sessionID);
        return this.connection.sendAndWaitReply(packet, timeout);
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) throws JMSException {
        packet.setSessionID(this.sessionID);
        return this.connection.sendSyncRequest(packet);
    }

    public void cancelSyncRequest(JMSSyncRequest request) {
        this.connection.cancelSyncRequest(request);
    }

    public void sendNotifyMessage(MessageContainer packet) throws JMSException {
        packet.setSessionID(this.sessionID);
        this.connection.sendNotifyMessage(packet);
    }

    public void flushWorks() {
        this.connection.flushWorks();
    }

    private void sendTransactionDecision(byte opcode, boolean rolledback) throws JMSException {
        AdminMessage commit = this.createAdminMessage(opcode);
        commit.setBooleanFlag(rolledback);
        this.sendAndWaitReply(commit, JMSServerEntry.TX_MESSAGE_TIMEOUT);
    }

    private void checkTransactionStatus() throws JMSException {
        if (this.isXAParticipant() || !this.isLocalTransacted()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3105, 1);
        }
    }

    public void enlistGlobalTransaction() {
    }

    public void delistGlobalTransaction() {
    }

    public boolean supportXA() {
        return false;
    }

    public void clientAcknowledge() throws JMSException {
        this.checkClosed();
        if (this.ackMode == 2) {
            this.acknowledgeAll();
            this.doFinishWorks();
        }
    }

    public void acknowledgeAll() throws JMSException {
        this.acknowledgeConsumers();
        if (this.consumer == null || this.ackManager.isEmpty()) {
            return;
        }
        this.ackManager.acknowledge(this.isTransacted());
    }

    public void recoverAll() throws JMSException {
        this.recoverConsumers();
        if (this.consumer == null || this.ackManager.isEmpty()) {
            return;
        }
        this.ackManager.recoverRemote();
    }

    public void clearAll() {
        this.clearConsumers();
        if (this.consumer == null || this.ackManager.isEmpty()) {
            return;
        }
        this.ackManager.clearConsumed(false);
    }

    public void assignConnectionConsumer(JeusConnectionConsumer consumer) {
        if (this.ackManager == null || consumer != this.consumer) {
            this.ackManager = new AcknowledgeManager(this.sessionID, consumer);
        }
        this.consumer = consumer;
    }

    public boolean isLocalTransacted() {
        return !this.closed.get() && super.isLocalTransacted();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String toString() {
        return this.sessionName;
    }

    protected void handleAsyncConsumeRuntimeException(RuntimeException e) {
        e.printStackTrace();
    }

    private class TransactedMessageQueue
    extends ClientSerialExecutable {
        private TransactedMessageQueue() {
        }

        public void preExecution(ClientMessage message) throws JMSException {
            message.setTransacted(true);
            message.setDelayed(true);
        }

        public boolean execute(ClientMessage message) throws Exception {
            JeusSession.this.sendMessage(message, false);
            return true;
        }
    }

    private class AsyncMessageQueue
    extends ClientSerialExecutable {
        private AsyncMessageQueue() {
        }

        public void workStarted() {
            super.workStarted();
            JeusSession.this.sessionEngaged();
        }

        public void preExecution(ClientMessage message) throws JMSException {
            message.setExecutionSession(JeusSession.this);
        }

        public boolean execute(ClientMessage message) throws Exception {
            return JeusSession.this.asyncConsumeMessage(message);
        }

        public void exception(ClientMessage message, JMSException e) {
            super.exception(message, e);
            Exception linkedException = e.getLinkedException();
            if (linkedException instanceof RuntimeException) {
                JeusSession.this.handleAsyncConsumeRuntimeException((RuntimeException)linkedException);
            }
        }

        public void failed(ClientMessage message, Throwable t) {
            if (t instanceof RuntimeException) {
                JeusSession.this.handleAsyncConsumeRuntimeException((RuntimeException)t);
            } else {
                super.failed(message, t);
            }
        }

        public void workCompleted() {
            JeusSession.this.sessionReleased();
            JeusSession.this.doFinishWorks();
        }
    }

    private class Dispatcher
    extends ClientSerialExecutable {
        private Dispatcher() {
        }

        public void workStarted() {
            super.workStarted();
            if (LogUtils.isLoggable(AbstractSession.logger, JeusMessage_JMS2._2338_LEVEL)) {
                LogUtils.log(AbstractSession.logger, JeusMessage_JMS2._2338_LEVEL, JeusMessage_JMS2._2338, new Object[]{this, JeusSession.this});
            }
        }

        public boolean execute(ClientMessage message) throws Exception {
            int consumerID = message.getConsumerID();
            ClientFacility consumer = JeusSession.this.findConsumer(consumerID);
            if (consumer == null) {
                JeusSession.this.sendBackMessage(message);
                return false;
            }
            consumer.handleMessage(message);
            return true;
        }

        public void exception(ClientMessage message, JMSException e) {
            if (LogUtils.isLoggable(AbstractSession.logger, JeusMessage_JMS2._2339_LEVEL)) {
                LogUtils.log(AbstractSession.logger, JeusMessage_JMS2._2339_LEVEL, JeusMessage_JMS2._2339, message, (Throwable)e);
            }
        }

        public void failed(ClientMessage message, Throwable t) {
            if (LogUtils.isLoggable(AbstractSession.logger, JeusMessage_JMS2._2340_LEVEL)) {
                LogUtils.log(AbstractSession.logger, JeusMessage_JMS2._2340_LEVEL, JeusMessage_JMS2._2340, message, t);
            }
        }

        public void workCompleted() {
            if (LogUtils.isLoggable(AbstractSession.logger, JeusMessage_JMS2._2341_LEVEL)) {
                LogUtils.log(AbstractSession.logger, JeusMessage_JMS2._2341_LEVEL, JeusMessage_JMS2._2341, new Object[]{this, JeusSession.this});
            }
        }
    }
}

