/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.session;

import java.io.IOException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.client.facility.connection.JeusXAConnection;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.GlobalTransactionMessage;
import jeus.jms.common.message.admin.GlobalTransactionRecoverMessage;
import jeus.jms.common.util.JMSXid;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public class JeusXASession
extends JeusSession
implements XAQueueSession,
XATopicSession,
XAResource {
    private JeusXAConnection connection;
    private TransactionProvider transactionProvider;
    public static final int FAILURE_ON_PREPARE = 1;
    public static final int FAILURE_ON_DECISION = 2;
    private int failurePhase = 0;
    private boolean xaParticipant;
    private boolean xaEnlisted;
    private long xaTimeout = JMSServerEntry.TX_MESSAGE_TIMEOUT;
    private Xid xaXid;

    public JeusXASession(JeusXAConnection connection, int type) {
        super((Connection)connection, 1, type);
        this.connection = connection;
        this.transactionProvider = TransactionProvider.getTransactionProvider();
    }

    AdminMessage getCreateSessionMessage(boolean recover) {
        AdminMessage create = super.getCreateSessionMessage(recover);
        create.setBooleanFlag(true);
        return create;
    }

    public void afterCompletion(int status) {
        super.afterCompletion(status);
        this.xaParticipant = false;
        this.xaEnlisted = false;
        this.xaXid = null;
    }

    void setFacilityName() {
        this.sessionName = this.connection.getFacilityName() + ".XS" + this.sessionID;
    }

    void sessionEngaged() {
        this.enlistConnectionConsumer();
        this.connection.workStarted((XASession)this);
    }

    void sessionReleased() {
        this.delistConnectionConsumer();
        this.connection.workCompleted((XASession)this);
    }

    void prepareClose() {
        if (this.isXAEnlisted()) {
            this.delistXAResource();
        }
        super.prepareClose();
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public QueueSession getQueueSession() throws JMSException {
        return this;
    }

    public TopicSession getTopicSession() throws JMSException {
        return this;
    }

    public boolean supportXA() {
        return true;
    }

    public void enlistGlobalTransaction() {
        if (!this.isSharedResource() && !this.isXAEnlisted()) {
            this.enlistXAResource();
        }
    }

    public void delistGlobalTransaction() {
        if (!this.isSharedResource() && !this.isXAEnlisted()) {
            this.delistXAResource();
        }
    }

    public XAResource getXAResource() {
        return this.transactionProvider.getXAResource(this);
    }

    private void enlistXAResource() {
        Transaction current = this.transactionProvider.getTransaction();
        if (current == null) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2271_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2271_LEVEL, JeusMessage_JMS2._2271);
        }
        try {
            XAResource xaResource = this.getXAResource();
            current.enlistResource(xaResource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void delistXAResource() {
        Transaction current = this.transactionProvider.getTransaction();
        if (current == null) {
            return;
        }
        try {
            XAResource xaResource = this.getXAResource();
            current.delistResource(xaResource, 0x4000000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleAsyncConsumeRuntimeException(RuntimeException e) {
        Transaction current = this.transactionProvider.getTransaction();
        if (current != null) {
            throw e;
        }
    }

    private boolean equals(Xid xid) {
        return this.xaXid != null && this.xaXid.equals(xid);
    }

    public void setFailurePhase(int phase) {
        this.failurePhase = phase;
    }

    private void throwFailure() throws XAException {
        this.failurePhase = 0;
        System.out.println("*************************** Disconnect or shutdown jms server and press any key.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new XAException(-7);
    }

    public void start(Xid xid, int flag) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2272_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2272_LEVEL, JeusMessage_JMS2._2272, new Object[]{this, Integer.toHexString(flag), xid.getClass().getName()});
        }
        if (this.equals(xid) && this.xaEnlisted) {
            throw new XAException(-8);
        }
        AdminMessage result = this.requestXATranasction((byte)96, xid, flag);
        if (result.getByteFlag() == -1) {
            throw new XAException(-3);
        }
        this.xaXid = xid;
        this.xaParticipant = true;
        this.xaEnlisted = true;
    }

    public void end(Xid xid, int flag) throws XAException {
        AdminMessage result;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2273_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2273_LEVEL, JeusMessage_JMS2._2273, new Object[]{this, Integer.toHexString(flag), xid.getClass().getName()});
        }
        if (this.equals(xid) && !this.xaEnlisted) {
            throw new XAException(-4);
        }
        switch (flag) {
            case 0x2000000: 
            case 0x4000000: {
                if (!this.equals(xid)) break;
                try {
                    this.flushTransaction();
                    break;
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    Exception linkedEx = e.getLinkedException();
                    if (linkedEx instanceof IOException) {
                        throw new XAException(-7);
                    }
                    throw new XAException(-3);
                }
            }
            case 0x20000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        if ((result = this.requestXATranasction((byte)97, xid, flag)).getByteFlag() == -1) {
            throw new XAException(-3);
        }
        this.xaEnlisted = false;
    }

    public int prepare(Xid xid) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2274_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2274_LEVEL, JeusMessage_JMS2._2274, new Object[]{this, xid.getClass().getName()});
        }
        if (this.equals(xid) && !this.xaParticipant) {
            throw new XAException(-4);
        }
        if (this.equals(xid) && this.failurePhase == 1) {
            this.throwFailure();
        }
        AdminMessage response = this.requestXATranasction((byte)98, xid);
        int result = response.getIntegerFlag();
        if (this.equals(xid) && result == 3) {
            this.xaParticipant = false;
            this.afterCompletion(3);
        }
        return result;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2275_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2275_LEVEL, JeusMessage_JMS2._2275, new Object[]{this, xid.getClass().getName()});
        }
        if (this.equals(xid) && this.failurePhase == 2) {
            this.throwFailure();
        }
        try {
            AdminMessage response = this.requestXATranasction((byte)99, xid, onePhase);
            switch (response.getByteFlag()) {
                case 0: {
                    if (this.equals(xid)) {
                        this.xaParticipant = false;
                        this.afterCompletion(3);
                    }
                    break;
                }
                case -1: {
                    throw (XAException)response.getException().getLinkedException();
                }
                default: {
                    throw new XAException(-6);
                }
            }
        }
        catch (XAException e) {
            if (this.equals(xid) && onePhase) {
                this.xaParticipant = false;
                this.afterCompletion(4);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2276_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2276_LEVEL, JeusMessage_JMS2._2276, new Object[]{this, xid.getClass().getName()});
        }
        if (this.equals(xid) && this.failurePhase == 2) {
            this.throwFailure();
        }
        XAException xaException = null;
        try {
            AdminMessage response = this.requestXATranasction((byte)100, xid, this.xaParticipant);
            switch (response.getByteFlag()) {
                case 0: {
                    this.xaParticipant = false;
                    break;
                }
                case -1: {
                    throw (XAException)response.getException().getLinkedException();
                }
                default: {
                    throw new XAException(-6);
                }
            }
        }
        catch (XAException e) {
            if (e.errorCode == -7) {
                throw e;
            }
            xaException = e;
        }
        if (this.equals(xid)) {
            try {
                this.clearTransaction();
            }
            catch (JMSException e) {
                if (xaException == null) {
                    throw new XAException(-3);
                }
            }
            finally {
                this.xaParticipant = false;
                this.afterCompletion(4);
            }
        }
        if (xaException != null) {
            throw xaException;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2277_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2277_LEVEL, JeusMessage_JMS2._2277, new Object[]{this, xid.getClass().getName()});
        }
        AdminMessage response = this.requestXATranasction((byte)101, xid);
        switch (response.getByteFlag()) {
            case 0: {
                if (!this.equals(xid)) break;
                this.afterCompletion(6);
                break;
            }
            case -1: {
                throw (XAException)response.getException().getLinkedException();
            }
            default: {
                throw new XAException(-6);
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        return (int)this.xaTimeout / 1000;
    }

    public boolean isSameRM(XAResource xares) {
        if (!(xares instanceof JeusXASession)) {
            return false;
        }
        JeusXASession another = (JeusXASession)xares;
        return this.sessionName.equals(another.sessionName);
    }

    public Xid[] recover(int flag) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2278_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2278_LEVEL, JeusMessage_JMS2._2278, new Object[]{this, Integer.toHexString(flag)});
        }
        GlobalTransactionRecoverMessage recover = new GlobalTransactionRecoverMessage();
        recover.setIntegerFlag(flag);
        try {
            recover = (GlobalTransactionRecoverMessage)this.request(recover, this.xaTimeout);
            return recover.getXidList();
        }
        catch (JMSException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2279_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2279_LEVEL, JeusMessage_JMS2._2279, this, (Throwable)e);
            }
            throw new XAException(-3);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.xaTimeout = seconds == 0 ? JMSServerEntry.TX_MESSAGE_TIMEOUT : (long)(seconds * 1000);
        return true;
    }

    private AdminMessage requestXATranasction(byte action, Xid xid) throws XAException {
        return this.requestXATranasction(action, xid, 0, false);
    }

    private AdminMessage requestXATranasction(byte action, Xid xid, int flag) throws XAException {
        return this.requestXATranasction(action, xid, flag, false);
    }

    private AdminMessage requestXATranasction(byte action, Xid xid, boolean flag) throws XAException {
        return this.requestXATranasction(action, xid, 0, flag);
    }

    private AdminMessage requestXATranasction(byte action, Xid xid, int flag, boolean flag2) throws XAException {
        GlobalTransactionMessage message = new GlobalTransactionMessage(action, new JMSXid(xid), this.xaTimeout);
        message.setTargetID(this.getTargetID(action));
        message.setIntegerFlag(flag);
        message.setBooleanFlag(flag2);
        try {
            return this.request(message, this.xaTimeout);
        }
        catch (JMSException e) {
            Exception linkedEx;
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2280_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2280_LEVEL, JeusMessage_JMS2._2280, e);
            }
            if ((linkedEx = e.getLinkedException()) instanceof IOException) {
                throw new XAException(-7);
            }
            throw new XAException(-3);
        }
    }

    protected AdminMessage request(AdminMessage packet, long timeout) throws JMSException {
        return this.sendAndWaitReply(packet, timeout);
    }

    private byte getTargetID(byte action) {
        boolean session = action == 96 || action == 97;
        return session ? (byte)15 : 3;
    }

    public boolean isXAEnlisted() {
        return this.xaEnlisted;
    }

    public boolean isXAParticipant() {
        return this.xaParticipant;
    }

    public boolean isSharedResource() {
        return false;
    }
}

