/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.message;

import java.io.DataInput;
import java.io.IOException;
import jeus.jms.common.message.BytesMessageImpl;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.EmptyMessage;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.MapMessageImpl;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.ObjectMessageImpl;
import jeus.jms.common.message.StreamMessageImpl;
import jeus.jms.common.message.TextMessageImpl;
import jeus.jms.common.util.MemoryBufferInputStream;
import jeus.nio.ByteBufferWrapper;

public class ClientMessageFactory
extends MessageFactory {
    public static MessageContainer createMessage(byte[] data) throws IOException {
        ByteBufferWrapper buffer = ByteBufferWrapper.wrap(data);
        return ClientMessageFactory.createClientMessage(buffer);
    }

    public static MessageContainer createClientMessage(ByteBufferWrapper buffer) throws IOException {
        MemoryBufferInputStream in = new MemoryBufferInputStream(buffer);
        MetaHeader metaHeader = new MetaHeader(in);
        return ClientMessageFactory.createClientMessage(metaHeader, buffer);
    }

    public static MessageContainer createClientMessage(MetaHeader metaHeader, ByteBufferWrapper buffer) throws IOException {
        MemoryBufferInputStream in = new MemoryBufferInputStream(buffer);
        if (metaHeader.isAdminMessage()) {
            return ClientMessageFactory.createAdminMessage(metaHeader, in);
        }
        return ClientMessageFactory.createUserMessage(metaHeader, in);
    }

    public static ClientMessage createUserMessage(MetaHeader metaHeader, DataInput in) throws IOException {
        ClientMessage message = ClientMessageFactory.createUserMessage(metaHeader);
        message.readMessage(in);
        return message;
    }

    public static ClientMessage createUserMessage(MetaHeader metaHeader) {
        ClientMessage message;
        switch (metaHeader.getMessageType()) {
            case 84: {
                message = new TextMessageImpl(metaHeader);
                break;
            }
            case 66: {
                message = new BytesMessageImpl(metaHeader);
                break;
            }
            case 79: {
                message = new ObjectMessageImpl(metaHeader);
                break;
            }
            case 77: {
                message = new MapMessageImpl(metaHeader);
                break;
            }
            case 83: {
                message = new StreamMessageImpl(metaHeader);
                break;
            }
            case 69: {
                message = new EmptyMessage(metaHeader);
                break;
            }
            case 70: {
                message = new FileMessageImpl(metaHeader);
                break;
            }
            default: {
                throw new RuntimeException("invalid user message type 0x" + Integer.toHexString(metaHeader.getMessageType()));
            }
        }
        return message;
    }
}

