/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common;

import java.io.File;
import jeus.jms.common.JMSProperties;
import jeus.jms.server.manager.ClusterManager;

public class JMSEnvironmentValues {
    static final String fs = File.separator;
    static final String SERVER_WORKDIR;
    static final String SERVER_FILEMSG_DIR;
    static final String CLIENT_WORKDIR;
    static final String LOG_HOME;

    public static String getServerEmbeddedDBDir() {
        return JMSEnvironmentValues.getServerEmbeddedDBDir(ClusterManager.LOCAL_BROKER_NAME);
    }

    public static String getServerEmbeddedDBDir(String brokerName) {
        return LOG_HOME + fs + "jms" + fs + brokerName + fs + "db";
    }

    public static String getServerFileMsgDir() {
        if (SERVER_FILEMSG_DIR == null) {
            return JMSProperties.getServerWorkingDir();
        }
        return SERVER_FILEMSG_DIR;
    }

    public static String getClientWorkDir() {
        if (CLIENT_WORKDIR == null) {
            return JMSProperties.getClientWorkingDir();
        }
        return CLIENT_WORKDIR;
    }

    public static String getClientEmbeddedDBDir() {
        return JMSEnvironmentValues.getClientWorkDir() + fs + "logs" + fs + "db";
    }

    static {
        Class<?> propertyClass = null;
        try {
            propertyClass = JMSEnvironmentValues.class.getClassLoader().loadClass("jeus.util.JeusProperties");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (propertyClass != null) {
            try {
                String JEUS_HOME = (String)propertyClass.getField("JEUS_HOME").get(null);
                if (JEUS_HOME != null) {
                    LOG_HOME = (String)propertyClass.getField("JEUS_LOG_HOME").get(null);
                    SERVER_WORKDIR = LOG_HOME + fs + "jms" + fs + ClusterManager.LOCAL_BROKER_NAME;
                    SERVER_FILEMSG_DIR = SERVER_WORKDIR + fs + "filemsgs";
                    CLIENT_WORKDIR = SERVER_WORKDIR + fs + "client";
                }
                LOG_HOME = null;
                SERVER_WORKDIR = null;
                SERVER_FILEMSG_DIR = null;
                CLIENT_WORKDIR = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            LOG_HOME = null;
            SERVER_WORKDIR = null;
            SERVER_FILEMSG_DIR = null;
            CLIENT_WORKDIR = null;
        }
    }
}

