/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common;

import java.io.File;
import jeus.jms.MessageTransformer;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.PropertyUtil;
import jeus.util.JeusBootstrapProperties;

public class JMSProperties
extends JeusBootstrapProperties {
    public static boolean CLIENT_MODE = true;
    public static final String KEY_CLIENT_CONNECT_TIMEOUT = "jeus.jms.client.connect.timeout";
    public static final String KEY_CLIENT_RECONNECT_TIMEOUT = "jeus.jms.client.reconnect.timeout";
    public static final String KEY_CLIENT_TRANSFER_BLOCK_SIZE = "jeus.jms.client.transfer.block";
    public static final String KEY_CLIENT_WORKING_DIR = "jeus.jms.client.workdir";
    public static final String KEY_SERVER_WORKING_DIR = "jeus.jms.server.workdir";
    public static final boolean TRY_CONNECT_EVER_FOR_EXCEPTION_LISTENER = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.connectForExceptionListener", (boolean)false);
    public static final boolean ENABLE_SAF = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.enableSAF", (boolean)false);
    public static final int SAF_ENGINE_PORT = JMSProperties.getIntSystemProperty((String)"jeus.jms.client.saf.port", (int)9741);
    public static final boolean TRY_CONNECT_EVER = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.connectForException", (boolean)true);
    public static final int STANDALONE_JMX_PORT = JMSProperties.getIntSystemProperty((String)"jeus.jms.jmx.port", (int)9000);
    public static final boolean DO_CONNECTION_FAILOVER = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.failover", (boolean)true);
    public static final int FILE_MESSAGE_BLOCK_SIZE = JMSProperties.getIntSystemProperty((String)"jeus.jms.file.blocksize", (int)4096);
    public static final String FILE_MESSAGE_TRANSFORMER_CLASS = JMSProperties.getSystemProperty((String)"jeus.jms.transformer");
    public static final boolean REMOVE_FILE_AFTER_ON_MESSAGE = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.server.deleteFileMessage", (boolean)true);
    public static final int CLIENT_MAX_THREAD = JMSProperties.getIntSystemProperty((String)"jeus.jms.client.maxThread", (int)100);
    public static final boolean DEBUG_TRANSFORMER = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.transformer.debug", (boolean)false);
    public static final boolean OPTIMIZED_PRODUCE = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.optimizedProduce", (boolean)false);
    public static final boolean CLOSE_CONSUMER_WHEN_CONNECTION_STOP = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.closeConsumerWhenConnectionStop", (boolean)false);
    public static final boolean DELETE_TABLES_ON_START = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.server.deleteTablesOnStart", (boolean)false);
    public static final int ROW_FETCH_SIZE = JMSProperties.getIntSystemProperty((String)"jeus.jms.server.rowFetchSize", (int)1000);
    public static final int BATCH_DELETE_SIZE = JMSProperties.getIntSystemProperty((String)"jeus.jms.server.batchDeleteSize", (int)20);
    public static final long TRASH_QUEUE_POLL_TIMEOUT = JMSProperties.getLongSystemProperty((String)"jeus.jms.server.trashQueuePollTimeout", (long)500L);
    public static final long FLUSH_TRASHCAN_INTERVAL = JMSProperties.getLongSystemProperty((String)"jeus.jms.server.flushTranshcanInterval", (long)5000L);
    public static final long SQL_QUEUE_POLL_TIMEOUT = JMSProperties.getLongSystemProperty((String)"jeus.jms.server.sqlQueuePollTimeout", (long)500L);
    public static final long LOW_PRIORITY_SQL_DELAY = JMSProperties.getLongSystemProperty((String)"jeus.jms.server.lowPrioritySqlDelay", (long)1000L);
    public static final long SQL_IDLE_TIME = JMSProperties.getLongSystemProperty((String)"jeus.jms.server.sqlIdleTime", (long)-1L);
    public static final int DELETE_PARTITION_SIZE = JMSProperties.getIntSystemProperty((String)"jeus.jms.server.deletePartitionSize", (int)1000);
    public static final String LIFECYCLE_LOGGER_DIR = "jeus.jms.server.lifecycleLoggerDir";
    public static final boolean USE_DIRECT_BUFFER = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.useDirectByteBuffer", (boolean)false);
    public static final boolean CLIENT_FORCE_SOCKET_SELECTOR = JMSProperties.getBooleanSystemProperty((String)"jeus.jms.client.forceSocketSelector", (boolean)false);
    public static final MessageTransformer transformer;
    private static BoundedInteger partialIdGenerator;

    public static long getClientConnectTimeout() {
        return PropertyUtil.getLongProperty(KEY_CLIENT_CONNECT_TIMEOUT, 5000L);
    }

    public static long getClientReconnectTimeout() {
        return PropertyUtil.getLongProperty(KEY_CLIENT_RECONNECT_TIMEOUT, 60000L);
    }

    public static int getClientTransferBlock() {
        return PropertyUtil.getIntProperty(KEY_CLIENT_TRANSFER_BLOCK_SIZE, 4096);
    }

    public static String getClientWorkingDir() {
        return PropertyUtil.getStringProperty(KEY_CLIENT_WORKING_DIR, System.getProperty("user.dir") + File.separator + "jeusmq_client_work");
    }

    public static String getServerWorkingDir() {
        return PropertyUtil.getStringProperty(KEY_SERVER_WORKING_DIR, System.getProperty("user.dir") + File.separator + "jeusmq_server_work");
    }

    public static String getLifecycleLoggerDir() {
        return PropertyUtil.getStringProperty(LIFECYCLE_LOGGER_DIR, System.getProperty("user.dir") + File.separator + "jeusmq_lifecycle");
    }

    public static MessageTransformer getTransformer() {
        return transformer;
    }

    public static short getNextPartialID() {
        return (short)partialIdGenerator.getNextValue();
    }

    static {
        if (FILE_MESSAGE_TRANSFORMER_CLASS != null) {
            try {
                transformer = (MessageTransformer)FileMessageImpl.class.getClassLoader().loadClass(FILE_MESSAGE_TRANSFORMER_CLASS).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot load transformer class : " + FILE_MESSAGE_TRANSFORMER_CLASS);
            }
        } else {
            transformer = null;
        }
        partialIdGenerator = new BoundedInteger(0, Short.MAX_VALUE, true);
    }
}

