/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.io.IOException;
import jeus.io.handler.ByteArrayIterator;
import jeus.io.impl.blocking.protocol.message.BlockingContentWriter;
import jeus.jms.common.comm.BaseByteArrayIterator;
import jeus.jms.common.message.IntermediateSendMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;
import jeus.util.ByteUtil;

public class JMSBlockingContentWriter
extends BlockingContentWriter {
    public boolean canWriteAsByte(Object toBeWritten) {
        return toBeWritten instanceof MessageContainer;
    }

    public boolean canWritePiggybackDataAsByte(Object piggybackData) {
        return piggybackData instanceof AdminMessage;
    }

    public byte[] getPiggybackDataBuffer(Object piggybackData) throws IOException {
        return MessageFactory.chunkedArrayForWrite((AdminMessage)piggybackData);
    }

    public ByteArrayIterator getBufferAsByte(Object toBeWrite, byte[] header) throws IOException {
        return new IteratorImpl(((MessageContainer)toBeWrite).getWritableMessage(false));
    }

    private class IteratorImpl
    extends BaseByteArrayIterator {
        public IteratorImpl(IntermediateSendMessage message) {
            super(false, message);
        }

        public Object next() {
            byte[] header = new byte[8];
            System.arraycopy(BYTE_MAGIC_BYTE, 0, header, 0, BYTE_MAGIC_BYTE.length);
            int length = 0;
            ByteArray[] arrays = new ByteArray[this.jeusBuffers.length + 1];
            arrays[0] = new ByteArray(header);
            for (int i = 0; i < this.jeusBuffers.length; ++i) {
                ByteBufferWrapper buffer = this.jeusBuffers[i];
                ByteArray array = buffer.array();
                length += array.getLength();
                arrays[i + 1] = array;
            }
            ByteUtil.putInt((byte[])header, (int)4, (int)length);
            return arrays;
        }
    }
}

