/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.net.ssl.SSLServerSocketFactory;
import jeus.util.JeusProperties;

public abstract class SSLParameterFactory {
    public static final String KEY_STORE_TYPE = "jeus.jms.ssl.keystore.type";
    public static final String KEY_STORE_PASS = "jeus.jms.ssl.keystore.passphrase";
    public static final String KEY_STORE_FILE = "jeus.jms.ssl.keystore.file";
    public static final String KEY_MANAGEMENT_ALGORITHM = "jeus.jms.ssl.keymanagement.algorithm";
    public static final String TRUST_STORE_TYPE = "jeus.jms.ssl.truststore.type";
    public static final String TRUST_STORE_PASS = "jeus.jms.ssl.truststore.passphrase";
    public static final String TRUST_STORE_FILE = "jeus.jms.ssl.truststore.file";
    public static final String TRUST_MANAGEMENT_ALGORITHM = "jeus.jms.ssl.trustmanagement.algorithm";
    public static final String PROTOCOL = "jeus.jms.ssl.protocol";
    private static SSLParameterFactory factory;
    public static SSLParameter NULL_PARAMETER;

    public static SSLParameterFactory getFactory() {
        if (factory == null) {
            try {
                Constructor<?> factoryConstructor = !JeusProperties.isUpperJDK4() ? Class.forName("jeus.jms.common.comm.JDK13SSLParameterFactory").getConstructor(null) : Class.forName("jeus.jms.common.comm.JDK14SSLParameterFactory").getConstructor(null);
                factory = (SSLParameterFactory)factoryConstructor.newInstance(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return factory;
    }

    public abstract SSLParameter createSSLParameter(Properties var1, boolean var2);

    static {
        NULL_PARAMETER = new SSLParameter(null, null);
    }

    public static class SSLParameter {
        private Object sslContext;
        private SSLServerSocketFactory sslServerSocketFactory;

        public SSLParameter(Object sslContext, SSLServerSocketFactory sslServerSocketFactory) {
            this.sslContext = sslContext;
            this.sslServerSocketFactory = sslServerSocketFactory;
        }

        public Object getSSLContext() {
            return this.sslContext;
        }

        public SSLServerSocketFactory getSSLServerSocketFactory() {
            return this.sslServerSocketFactory;
        }
    }
}

