/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.logger;

import java.util.logging.Level;
import jeus.util.logging.JeusLevel;

public class JMSLevel {
    public static final int OFF = Level.OFF.intValue();
    public static final int FATAL = JeusLevel.FATAL.intValue();
    public static final int NOTICE = JeusLevel.NOTICE.intValue();
    public static final int INFORM = JeusLevel.INFORMATION.intValue();
    public static final int DEBUG = JeusLevel.DEBUG.intValue();

    public static int parse(String level) {
        if (level == null) {
            throw new IllegalArgumentException();
        }
        if ((level = level.toUpperCase()).equals("OFF")) {
            return OFF;
        }
        if (level.equals("FATAL")) {
            return FATAL;
        }
        if (level.equals("NOTICE")) {
            return NOTICE;
        }
        if (level.equals("DEBUG")) {
            return DEBUG;
        }
        if (level.equals("INFORMATION")) {
            return INFORM;
        }
        if (level.equals("DEV")) {
            return DEBUG;
        }
        try {
            return Level.parse(level).intValue();
        }
        catch (IllegalArgumentException e) {
            return FATAL;
        }
    }
}

