/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.session.SessionFacility;
import jeus.jms.client.message.ClientMessageFactory;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.util.AcknowledgeManager;
import jeus.jms.common.util.JMSByteArrayOutputStream;

public abstract class ClientMessage
extends UserMessage
implements Cloneable {
    private transient SessionFacility session;
    private transient ServerSession serverSession;
    private transient AcknowledgeManager ackManager;
    private transient MessageListener listener;
    private transient boolean returnBack;

    public ClientMessage(byte type) {
        super(type);
    }

    public ClientMessage(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public void checkAutoCompaction() {
        if (this.userCompaction() || !JMSServerEntry.USE_COMPRESS) {
            return;
        }
        long estimated = this.getEstimatedLength();
        this.setCompress(estimated > (long)JMSServerEntry.COMPRESS_THRESHOLD);
    }

    public long getEstimatedLength() {
        return 0L;
    }

    public void checkScheduledTime() {
        if (this.isScheduled()) {
            this.setScheduledTime(this.getScheduledTime() + this.getJMSTimestamp());
        }
    }

    public void writeBody(DataOutput out) throws IOException {
        out.writeBoolean(this.compress);
        if (this.compress) {
            JMSByteArrayOutputStream bos = new JMSByteArrayOutputStream(1024);
            DataOutputStream dos = new DataOutputStream(bos);
            this.marshal(dos);
            byte[] input = bos.getBuffer();
            int offset = bos.getValidBytesCount();
            byte[] output = new byte[offset + 256];
            int compressed = 0;
            Deflater deflater = new Deflater();
            deflater.setInput(input, 0, offset);
            do {
                compressed += deflater.deflate(output, compressed, output.length - compressed);
            } while (!deflater.needsInput());
            deflater.finish();
            do {
                compressed += deflater.deflate(output, compressed, output.length - compressed);
            } while (!deflater.finished());
            out.writeInt(offset);
            out.writeInt(compressed);
            out.write(output, 0, compressed);
        } else {
            this.marshal(out);
        }
    }

    public void readBody(DataInput in) throws IOException {
        this.compress = in.readBoolean();
        if (this.compress) {
            int org = in.readInt();
            int cur = in.readInt();
            byte[] output = new byte[org];
            byte[] input = new byte[cur];
            in.readFully(input);
            Inflater inflater = new Inflater();
            inflater.setInput(input);
            while (!inflater.finished()) {
                int uncompressed = 0;
                try {
                    uncompressed += inflater.inflate(output, uncompressed, output.length - uncompressed);
                }
                catch (DataFormatException dataformatexception) {
                    throw new IOException(dataformatexception.getMessage());
                }
                if (uncompressed < output.length) continue;
                byte[] newOutput = new byte[output.length + 4096];
                System.arraycopy(output, 0, newOutput, 0, output.length);
                output = newOutput;
            }
            in = new DataInputStream(new ByteArrayInputStream(output));
        }
        this.unmarshal(in);
    }

    abstract void marshal(DataOutput var1) throws IOException;

    abstract void unmarshal(DataInput var1) throws IOException;

    public void prepareMessage() {
        this.backupContents();
        this.setReadOnlyBody(true);
        this.setReadOnlyProperty(true);
    }

    public void setExecutionContext(AcknowledgeManager handler) {
        this.ackManager = handler;
    }

    public void setExecutionSession(SessionFacility session) {
        this.session = session;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public void setServerSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public void consuming(int ackmode) {
        if (!this.getDestination().isTemporary()) {
            this.messageID.setConsumed(true);
            this.ackManager.messageConsuming(ackmode, this);
        }
    }

    public void onMessage() {
        this.ackManager.onMessage(this.listener, this);
        this.listener.onMessage((Message)this);
    }

    public void consumed(int ackmode) throws JMSException {
        if (!this.getDestination().isTemporary()) {
            this.ackManager.messageConsumed(ackmode, this);
        }
    }

    public void acknowledge() throws JMSException {
        if (this.getDestination().isTemporary()) {
            return;
        }
        this.session.clientAcknowledge();
    }

    public void runtimeException(int ackmode, RuntimeException re) throws JMSException {
        if (this.getDestination().isTemporary()) {
            return;
        }
        this.ackManager.handleRuntimeException(ackmode, re, this);
    }

    public boolean isReturnBack() {
        return this.returnBack;
    }

    public void setReturnBack(boolean returnBack) {
        this.returnBack = returnBack;
    }

    public void recover(short brokerID, long entryID) {
        super.recover(brokerID, entryID);
        this.messageID = this.messageID.recreate(brokerID, entryID);
    }

    public ClientMessage getMessageClone() {
        ClientMessage message = ClientMessageFactory.createUserMessage(this.metaHeader.getClone());
        message.messageID = this.messageID.getClone();
        message.msgHeader = this.msgHeader.getClone();
        message.properties = this.properties == null ? null : this.properties.getClone();
        return message;
    }

    public abstract Object clone();

    public String toString() {
        return (this.getJMSRedelivered() ? "R:" : "F:") + super.toString();
    }
}

