/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MetaHeader;
import jeus.nio.ByteBufferWrapper;

public class IntermediateReceivedMessage
extends MessageContainer {
    private ByteBufferWrapper packet;

    public IntermediateReceivedMessage(MetaHeader header, ByteBufferWrapper packet) {
        super(header);
        this.packet = packet;
    }

    public ByteBufferWrapper getRawPacket() {
        return this.packet;
    }

    public void append(IntermediateReceivedMessage partial) {
        ByteBufferWrapper appender = partial.packet;
        ByteBufferWrapper appended = ByteBufferWrapper.allocate(this.packet.isDirect(), this.packet.remaining() + appender.remaining());
        appended.put(this.packet);
        appended.put(appender);
        ByteBufferWrapper.free(this.packet);
        this.packet = null;
        this.packet = appended;
        this.packet.flip();
    }

    public String toString() {
        return this.getPartialID() + ":" + this.getPartialSequence() + ":" + (this.isPartialEOF() ? "|" : "-") + ":" + this.packet;
    }

    public void writeExternal(DataOutput out) throws IOException {
    }

    public void readExternal(DataInput in) throws IOException {
    }
}

