/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageNotWriteableException;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageFieldEntry;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.EnumerationSet;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.ProtocolUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class MapMessageImpl
extends ClientMessage
implements MapMessage,
Cloneable {
    private HashMap map = new HashMap();
    private HashMap originalMap;

    public MapMessageImpl() {
        super((byte)77);
    }

    public MapMessageImpl(MetaHeader metaHeader) {
        super(metaHeader);
    }

    private MessageFieldEntry getEntry(String name) throws JMSException {
        this.checkArgument(name);
        MessageFieldEntry entry = (MessageFieldEntry)this.map.get(name);
        if (entry == null) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4008, name);
        }
        return entry;
    }

    private MessageFieldEntry getObjectEntry(String name) {
        this.checkArgument(name);
        return (MessageFieldEntry)this.map.get(name);
    }

    public boolean getBoolean(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getBoolean();
    }

    public byte getByte(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getByte();
    }

    public short getShort(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getShort();
    }

    public char getChar(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        if (entry.getValue() == null) {
            throw new NullPointerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4008, (Object[])new String[]{name}));
        }
        return entry.getChar();
    }

    public int getInt(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getInt();
    }

    public long getLong(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getLong();
    }

    public float getFloat(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getFloat();
    }

    public double getDouble(String name) throws JMSException {
        MessageFieldEntry entry = this.getEntry(name);
        return entry.getDouble();
    }

    public String getString(String name) throws JMSException {
        MessageFieldEntry entry = this.getObjectEntry(name);
        if (entry == null) {
            return null;
        }
        return entry.getString();
    }

    public byte[] getBytes(String name) throws JMSException {
        MessageFieldEntry entry = this.getObjectEntry(name);
        if (entry == null) {
            return null;
        }
        return entry.getBytes();
    }

    public Object getObject(String name) throws JMSException {
        MessageFieldEntry entry = this.getObjectEntry(name);
        if (entry == null) {
            return null;
        }
        return entry.getObject();
    }

    public Enumeration getMapNames() throws JMSException {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return new EnumerationSet(this.map.keySet());
    }

    private void checkWritable(String name) throws MessageNotWriteableException {
        this.checkOutputStream();
        this.checkArgument(name);
    }

    private void checkArgument(String name) {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._3130));
        }
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(2, value ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(3, new Byte(value)));
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(8, new Short(value)));
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(9, new Character(value)));
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(1, new Integer(value)));
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(7, new Long(value)));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(4, new Float(value)));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(5, new Double(value)));
    }

    public void setString(String name, String value) throws JMSException {
        this.checkWritable(name);
        this.map.put(name, new MessageFieldEntry(6, value == null ? null : value));
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkWritable(name);
        byte[] array = new byte[value.length];
        System.arraycopy(value, 0, array, 0, value.length);
        this.map.put(name, new MessageFieldEntry(10, array));
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkWritable(name);
        byte[] array = new byte[length];
        System.arraycopy(value, offset, array, 0, length);
        this.map.put(name, new MessageFieldEntry(10, array));
    }

    public void setObject(String name, Object value) throws JMSException {
        int type;
        this.checkWritable(name);
        if (value == null || value instanceof String) {
            type = 6;
        } else if (value instanceof Byte) {
            type = 3;
        } else if (value instanceof Double) {
            type = 5;
        } else if (value instanceof Float) {
            type = 4;
        } else if (value instanceof Integer) {
            type = 1;
        } else if (value instanceof Long) {
            type = 7;
        } else if (value instanceof Short) {
            type = 8;
        } else if (value instanceof Boolean) {
            type = 2;
        } else if (value instanceof Character) {
            type = 9;
        } else if (value instanceof byte[]) {
            byte[] result = (byte[])value;
            byte[] array = new byte[result.length];
            System.arraycopy(result, 0, array, 0, result.length);
            type = 10;
        } else {
            throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4223));
        }
        this.map.put(name, new MessageFieldEntry((byte)type, value));
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsKey(name);
    }

    public void clearBody() {
        if (this.originalMap != null) {
            this.originalMap = this.map;
            this.map = new HashMap();
        } else {
            this.map.clear();
        }
        super.clearBody();
    }

    void marshal(DataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry e : this.map.entrySet()) {
            String name = (String)e.getKey();
            MessageFieldEntry entry = (MessageFieldEntry)e.getValue();
            ProtocolUtil.writeString(name, out);
            entry.marshal(out);
        }
    }

    void unmarshal(DataInput in) throws IOException {
        this.map.clear();
        int size = in.readInt();
        while (size-- > 0) {
            String name = ProtocolUtil.readString(in);
            MessageFieldEntry entry = new MessageFieldEntry(in);
            this.map.put(name, entry);
        }
    }

    protected void recoverBody() {
        if (this.originalMap != null) {
            this.map = this.originalMap;
            this.originalMap = null;
        }
    }

    public Object clone() {
        MapMessageImpl message = (MapMessageImpl)this.getMessageClone();
        message.map = (HashMap)this.map.clone();
        return message;
    }

    public String toString() {
        return "MapMessage " + super.toString();
    }
}

