/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.IOException;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.BrowseQueueMessage;
import jeus.jms.common.message.admin.CallBackAddressMessage;
import jeus.jms.common.message.admin.CheckDestinationMessage;
import jeus.jms.common.message.admin.CleanUpDurableSubscriberMessage;
import jeus.jms.common.message.admin.CleanUpQueueMessage;
import jeus.jms.common.message.admin.CreateConnectionMessage;
import jeus.jms.common.message.admin.CreateConsumerMessage;
import jeus.jms.common.message.admin.CreateDestinationMessage;
import jeus.jms.common.message.admin.CreateEntryMessage;
import jeus.jms.common.message.admin.CreateProducerMessage;
import jeus.jms.common.message.admin.CreateSessionMessage;
import jeus.jms.common.message.admin.DestinationCommandMessage;
import jeus.jms.common.message.admin.GetDurableMessageLifecycleMessage;
import jeus.jms.common.message.admin.GetMessageLifecycleMessage;
import jeus.jms.common.message.admin.GlobalTransactionMessage;
import jeus.jms.common.message.admin.GlobalTransactionRecoverMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.RegisterCallbackMessage;
import jeus.jms.common.message.admin.RequestConsumerCountMessage;
import jeus.jms.common.message.admin.RoutingInformation;
import jeus.jms.common.message.admin.SetClientIDMessage;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.common.message.admin.TakeoverMessage;
import jeus.jms.common.message.admin.UnsubscribeMessage;
import jeus.jms.common.util.MemoryBufferOutputStream;
import jeus.nio.ByteBufferWrapper;

public abstract class MessageFactory {
    private static final int ADMIN_MESSAGE_BUFFER = 128;
    private static final int USER_MESSAGE_BUFFER = 1024;

    public static void updateMetaHeader(MetaHeader header, ByteBufferWrapper packet) throws IOException {
        packet.position(0);
        MemoryBufferOutputStream out = new MemoryBufferOutputStream(packet);
        header.writeExternal(out);
        packet.position(0);
    }

    public static ByteBufferWrapper serializeForWrite(ISerializable target, int initial) throws IOException {
        return MessageFactory.serializeForWrite(target, initial, false);
    }

    public static ByteBufferWrapper serializeForWrite(ISerializable target, int initial, boolean direct) throws IOException {
        MemoryBufferOutputStream out = new MemoryBufferOutputStream(initial, direct);
        target.writeExternal(out);
        return out.getBuffer().flip();
    }

    public static ByteBufferWrapper serializeForWrite(MessageContainer target) throws IOException {
        return MessageFactory.serializeForWrite((ISerializable)target, target.isAdminMessage() ? 128 : 1024);
    }

    public static ByteBufferWrapper serializeForWrite(MessageContainer target, boolean direct) throws IOException {
        return MessageFactory.serializeForWrite(target, target.isAdminMessage() ? 128 : 1024, direct);
    }

    public static ByteBufferWrapper chunkedSerializeForWrite(MessageContainer target) throws IOException {
        ByteBufferWrapper buffer = MessageFactory.chunkedSerialize(target);
        return buffer.flip();
    }

    public static byte[] chunkedArrayForWrite(MessageContainer target) throws IOException {
        return MessageFactory.chunkedSerializeForWrite(target).compactArray();
    }

    public static ByteBufferWrapper chunkedSerialize(MessageContainer target) throws IOException {
        MemoryBufferOutputStream out = new MemoryBufferOutputStream(target.isAdminMessage() ? 128 : 1024, false);
        target.getMetaHeader().writeExternal(out);
        target.writeExternal(out);
        ByteBufferWrapper buffer = out.getBuffer();
        buffer.putInt(4, buffer.position());
        return buffer;
    }

    public static AdminMessage createAdminMessage(MetaHeader metaHeader, DataInput in) throws IOException {
        byte type = in.readByte();
        AdminMessage message = MessageFactory.createAdminMessage(metaHeader, type);
        message.readBody(in);
        return message;
    }

    private static AdminMessage createAdminMessage(MetaHeader metaHeader, byte opcode) throws IOException {
        switch (opcode) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 80: 
            case 81: 
            case 82: 
            case 111: {
                return new AdminMessage(metaHeader, opcode);
            }
            case 113: {
                return new TakeoverMessage(metaHeader, opcode);
            }
            case 13: 
            case 14: 
            case 16: {
                return new CreateEntryMessage(metaHeader, opcode);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                return new SingleMessageHandleEvent(metaHeader, opcode);
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return new MultipleMessageHandleEvent(metaHeader, opcode);
            }
            case 17: {
                return new CreateDestinationMessage(metaHeader);
            }
            case 26: {
                return new DestinationCommandMessage(metaHeader, opcode);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                return new GlobalTransactionMessage(metaHeader, opcode);
            }
            case 11: 
            case 12: {
                return new CreateConsumerMessage(metaHeader, opcode);
            }
            case 19: {
                return new RoutingInformation(metaHeader);
            }
            case 8: {
                return new CreateConnectionMessage(metaHeader);
            }
            case 9: {
                return new CreateSessionMessage(metaHeader);
            }
            case 20: {
                return new CallBackAddressMessage(metaHeader);
            }
            case 23: {
                return new SetClientIDMessage(metaHeader);
            }
            case 21: {
                return new CheckDestinationMessage(metaHeader);
            }
            case 22: {
                return new BrowseQueueMessage(metaHeader);
            }
            case 7: {
                return new UnsubscribeMessage(metaHeader);
            }
            case 102: {
                return new GlobalTransactionRecoverMessage(metaHeader);
            }
            case 10: {
                return new CreateProducerMessage(metaHeader);
            }
            case 112: {
                return new RegisterCallbackMessage(metaHeader);
            }
            case 24: {
                return new RequestConsumerCountMessage(metaHeader);
            }
            case -1: {
                return new GetMessageLifecycleMessage(metaHeader);
            }
            case -2: {
                return new CleanUpQueueMessage(metaHeader);
            }
            case -3: {
                return new CleanUpDurableSubscriberMessage(metaHeader);
            }
            case -4: {
                return new GetDurableMessageLifecycleMessage(metaHeader);
            }
        }
        throw new IOException("Unknown message type:" + opcode);
    }
}

