/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateEntryMessage;
import jeus.jms.common.message.admin.GlobalTransactionReplyMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;

public class MessageUtil {
    public static CreateEntryMessage createEstablishMessage(byte type, String brokerName, long requestID, boolean xaRecovery) {
        return new CreateEntryMessage(type, brokerName, requestID, xaRecovery);
    }

    public static CreateEntryMessage createClientEstablishMessage(String brokerName, long requestID) {
        return new CreateEntryMessage(13, brokerName, requestID);
    }

    public static CreateEntryMessage createServerEstablishMessage(String brokerName, long requestID) {
        return new CreateEntryMessage(14, brokerName, requestID);
    }

    public static CreateEntryMessage createServerEstablishMessage(String brokerName) {
        return new CreateEntryMessage(14, brokerName, -1L);
    }

    public static AdminMessage createEstablishAckMessage(String brokerName, long responseID) {
        return new CreateEntryMessage(16, brokerName, responseID);
    }

    public static AdminMessage createEstablishNackMessage(String brokerName, long responseID) {
        return new CreateEntryMessage(15, brokerName, responseID);
    }

    public static AdminMessage createAdminMessage(byte opcode) {
        return new AdminMessage(opcode);
    }

    public static AdminMessage createAdminMessage(byte targetID, byte opcode) {
        AdminMessage message = new AdminMessage(opcode);
        message.setTargetID(targetID);
        return message;
    }

    public static AdminMessage createAdminMessage(MetaHeader metaHeader) {
        return new AdminMessage(metaHeader);
    }

    public static GlobalTransactionReplyMessage createXAReplyMessage(MetaHeader metaHeader) {
        return new GlobalTransactionReplyMessage(metaHeader);
    }

    public static AdminMessage createAdminMessage(MetaHeader metaHeader, JMSException ex) {
        AdminMessage message = new AdminMessage(metaHeader);
        message.setException(ex);
        return message;
    }

    public static MessageHandleEvent createEventMessage(byte opcode, MessageID messageID) {
        return new SingleMessageHandleEvent(opcode, messageID);
    }

    public static MessageHandleEvent createEventMessage(byte opcode, MetaHeader metaHeader, MessageID messageID) {
        SingleMessageHandleEvent event = new SingleMessageHandleEvent(metaHeader, opcode);
        event.setMessageID(messageID);
        return event;
    }

    public static MessageHandleEvent createEventMessage(byte opcode, UserMessage message) {
        MetaHeader metaHeader = message.getMetaHeader().getClone();
        SingleMessageHandleEvent event = new SingleMessageHandleEvent(metaHeader, opcode);
        event.setMessageID(message.getMessageID());
        return event;
    }

    public static MessageHandleEvent createEventMessage(byte opcode, List works) {
        UserMessage message = (UserMessage)works.get(0);
        if (works.size() == 1) {
            return MessageUtil.createEventMessage(opcode, message);
        }
        opcode = (byte)(opcode + 16);
        return new MultipleMessageHandleEvent(opcode, message.getMetaHeader(), new LinkedList(works));
    }
}

