/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageFieldEntry;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.JMSByteArrayOutputStream;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.ProtocolUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class StreamMessageImpl
extends ClientMessage
implements StreamMessage,
Cloneable {
    private JMSByteArrayOutputStream bao;
    private transient DataOutputStream out;
    private transient DataInputStream in;
    private transient byte[] oldData;
    private transient byte[] field;
    private transient int offset;

    public StreamMessageImpl() {
        super((byte)83);
        this.bao = new JMSByteArrayOutputStream(32);
        this.out = new DataOutputStream(this.bao);
    }

    public StreamMessageImpl(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public Object clone() {
        StreamMessageImpl message = (StreamMessageImpl)this.getMessageClone();
        message.bao = this.cloneData();
        message.in = new DataInputStream(new ByteArrayInputStream(message.bao.getBuffer(), 0, message.bao.getValidBytesCount()));
        message.out = new DataOutputStream(message.bao);
        return message;
    }

    private JMSByteArrayOutputStream cloneData() {
        byte[] src = this.bao.getBuffer();
        byte[] dest = new byte[src.length];
        System.arraycopy(src, 0, dest, 0, src.length);
        int validBytesCount = this.bao.getValidBytesCount();
        return new JMSByteArrayOutputStream(dest, validBytesCount);
    }

    public void prepareMessage() {
        super.prepareMessage();
        this.reset();
    }

    void marshal(DataOutput out) throws IOException {
        ProtocolUtil.writeBytes(this.bao.getBuffer(), 0, this.bao.getValidBytesCount(), out);
    }

    void unmarshal(DataInput in) throws IOException {
        byte[] data = ProtocolUtil.readBytes(in);
        this.bao = new JMSByteArrayOutputStream(data, data.length);
    }

    private MessageFieldEntry readEntry() throws JMSException {
        this.in.mark(0);
        try {
            return new MessageFieldEntry(this.in);
        }
        catch (EOFException ioe) {
            try {
                this.in.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
            MessageEOFException ex = new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221));
            ex.setLinkedException((Exception)ioe);
            throw ex;
        }
        catch (IOException ioe) {
            try {
                this.in.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
            MessageFormatException ex = new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221));
            ex.setLinkedException((Exception)ioe);
            throw ex;
        }
    }

    public boolean readBoolean() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getBoolean();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public byte readByte() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getByte();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public short readShort() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getShort();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public char readChar() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        if (entry.getValue() == null) {
            throw new NullPointerException("null value poped up for char");
        }
        try {
            return entry.getChar();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public int readInt() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getInt();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public long readLong() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getLong();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public float readFloat() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getFloat();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public double readDouble() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getDouble();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public String readString() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        try {
            return entry.getString();
        }
        catch (NumberFormatException me) {
            try {
                this.in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw me;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkReadMode();
        if (this.field != null) {
            return this._readBytes(value);
        }
        MessageFieldEntry entry = this.readEntry();
        this.field = entry.getBytes(false);
        if (this.field == null) {
            return -1;
        }
        if (this.field.length == 0) {
            this.field = null;
            return 0;
        }
        return this._readBytes(value);
    }

    private int _readBytes(byte[] value) {
        this.in.mark(0);
        int remain = this.field.length - this.offset;
        int length = Math.min(remain, value.length);
        System.arraycopy(this.field, this.offset, value, 0, length);
        if (length < value.length) {
            this.offset = 0;
            this.field = null;
        } else {
            this.offset += length;
        }
        return length;
    }

    public Object readObject() throws JMSException {
        this.checkInputStream();
        MessageFieldEntry entry = this.readEntry();
        return entry.getObject();
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(2);
            this.out.writeBoolean(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(3);
            this.out.writeByte(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(8);
            this.out.writeShort(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(9);
            this.out.writeChar(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(1);
            this.out.writeInt(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(7);
            this.out.writeLong(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(4);
            this.out.writeFloat(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(5);
            this.out.writeDouble(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeString(String value) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(6);
            ProtocolUtil.writeString(value, this.out);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWriteMode();
        try {
            this.out.writeByte(10);
            ProtocolUtil.writeBytes(value, offset, length, this.out);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.checkWriteMode();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value == null) {
            this.writeString(null);
        } else {
            throw new MessageFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4223));
        }
    }

    public void reset() {
        byte[] buf = this.bao.getBuffer();
        int validBytesCount = this.bao.getValidBytesCount();
        this.in = new DataInputStream(new ByteArrayInputStream(buf, 0, validBytesCount));
        this.setReadOnlyBody(true);
    }

    public void clearBody() {
        if (this.oldData != null) {
            this.oldData = this.bao.getBuffer();
        }
        this.bao = new JMSByteArrayOutputStream(32);
        this.out = new DataOutputStream(this.bao);
        super.clearBody();
    }

    protected void recoverBody() {
        if (this.oldData != null) {
            this.bao = new JMSByteArrayOutputStream(this.oldData, this.bao.getValidBytesCount());
            this.out = new DataOutputStream(this.bao);
            this.oldData = null;
        }
    }

    private void checkInputStream() throws JMSException {
        this.checkReadMode();
        if (this.field != null && this.field.length > this.offset) {
            throw new MessageFormatException("current byte[] field is still remaining");
        }
    }

    public String toString() {
        return "StreamMessage " + super.toString();
    }
}

