/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.PublicAdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CleanUpDurableSubscriberMessage
extends PublicAdminMessage {
    private String clientID;
    private String durableName;

    public CleanUpDurableSubscriberMessage() {
    }

    public CleanUpDurableSubscriberMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)-3);
    }

    public CleanUpDurableSubscriberMessage(String clientID, String durableName) {
        super((byte)-3);
        this.clientID = clientID;
        this.durableName = durableName;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.clientID = ProtocolUtil.readString(in);
        this.durableName = ProtocolUtil.readString(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.clientID, out);
        ProtocolUtil.writeString(this.durableName, out);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",clientID").append(this.clientID);
        b.append(",durable name=").append(this.durableName);
        return b.toString();
    }
}

