/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public abstract class CommandMessage
extends AdminMessage {
    private String brokerName;
    private String destName;
    private String exportName;
    private boolean multipleReceiver;

    public CommandMessage(byte opcode, String brokerName, String destName, String exportName, boolean multipleReceiver) {
        super(opcode);
        this.brokerName = brokerName;
        this.destName = destName;
        this.exportName = exportName;
        this.multipleReceiver = multipleReceiver;
    }

    public CommandMessage(byte opcode, String destName) {
        super(opcode);
        this.destName = destName;
    }

    public CommandMessage(MetaHeader metaHeader, byte opcode) {
        super(metaHeader, opcode);
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getDestName() {
        return this.destName;
    }

    public String getExportName() {
        return this.exportName;
    }

    public boolean getMultipleReceiver() {
        return this.multipleReceiver;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.brokerName = ProtocolUtil.readString(in);
        this.destName = ProtocolUtil.readString(in);
        this.exportName = ProtocolUtil.readString(in);
        this.multipleReceiver = Boolean.valueOf(ProtocolUtil.readString(in));
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.brokerName, out);
        ProtocolUtil.writeString(this.destName, out);
        ProtocolUtil.writeString(this.exportName, out);
        ProtocolUtil.writeString(Boolean.toString(this.multipleReceiver), out);
    }

    public String toString() {
        return super.toString() + " {" + this.brokerName + ":" + this.destName + ":" + this.exportName + ":" + this.multipleReceiver + "}";
    }
}

