/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CreateConnectionMessage
extends AdminMessage {
    private String clientID;
    private String userName;
    private String password;

    public CreateConnectionMessage() {
        super((byte)8);
    }

    public CreateConnectionMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)8);
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setFixedClientID(boolean auto) {
        this.setBooleanFlag(auto);
    }

    public boolean isFixedClientID() {
        return this.getBooleanFlag();
    }

    public void setAllocatedConnectionID(int connectionID) {
        this.metaHeader.setConnectionID(connectionID);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.clientID = ProtocolUtil.readString(in);
        this.userName = ProtocolUtil.readString(in);
        this.password = ProtocolUtil.readString(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.clientID, out);
        ProtocolUtil.writeString(this.userName, out);
        ProtocolUtil.writeString(this.password, out);
    }
}

