/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CreateConsumerMessage
extends AdminMessage {
    private String durableName;
    private String destinationName;
    private String selector;
    private boolean noLocal;

    public CreateConsumerMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)11);
    }

    public CreateConsumerMessage(String destinationName) {
        super((byte)11);
        this.destinationName = destinationName;
    }

    public CreateConsumerMessage(MetaHeader metaHeader, byte opcode) {
        super(metaHeader, opcode);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void setAllocatedConsumerID(int id) {
        this.metaHeader.setConsumerID(id);
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.destinationName = ProtocolUtil.readString(in);
        this.selector = ProtocolUtil.readString(in);
        this.durableName = ProtocolUtil.readString(in);
        this.noLocal = in.readBoolean();
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.destinationName, out);
        ProtocolUtil.writeString(this.selector, out);
        ProtocolUtil.writeString(this.durableName, out);
        out.writeBoolean(this.noLocal);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",destination={").append(this.destinationName).append('}');
        b.append(",selector={").append(this.selector).append('}');
        b.append("}");
        return b.toString();
    }
}

