/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.PublicAdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class GetDurableMessageLifecycleMessage
extends PublicAdminMessage {
    private String clientID;
    private String durableName;
    private String destName;
    private MessageID messageID;

    public GetDurableMessageLifecycleMessage() {
    }

    public GetDurableMessageLifecycleMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)-4);
    }

    public GetDurableMessageLifecycleMessage(String destName, String clientID, String durableName, MessageID messageID) {
        super((byte)-4);
        this.destName = destName;
        this.clientID = clientID;
        this.durableName = durableName;
        this.messageID = messageID;
    }

    public String getDestinationName() {
        return this.destName;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.clientID = ProtocolUtil.readString(in);
        this.destName = ProtocolUtil.readString(in);
        this.durableName = ProtocolUtil.readString(in);
        this.messageID = new MessageID(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.clientID, out);
        ProtocolUtil.writeString(this.destName, out);
        ProtocolUtil.writeString(this.durableName, out);
        this.messageID.writeExternal(out);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(", client id=").append(this.clientID);
        b.append(", destination name=").append(this.destName);
        b.append(",durable name =").append(this.durableName);
        b.append(",message id =").append(this.messageID);
        return b.toString();
    }
}

