/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.JMSXid;

public class GlobalTransactionRecoverMessage
extends AdminMessage {
    private JMSXid[] xidList;

    public GlobalTransactionRecoverMessage() {
        super((byte)102);
        this.setTargetID((byte)3);
    }

    public GlobalTransactionRecoverMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)102);
    }

    public JMSXid[] getXidList() {
        return this.xidList;
    }

    public void setXidList(JMSXid[] xidList) {
        this.xidList = xidList;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.xidList = GlobalTransactionRecoverMessage.readXidArray(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        GlobalTransactionRecoverMessage.writeXidArray(this.xidList, out);
    }

    public static void writeXidArray(JMSXid[] value, DataOutput out) throws IOException {
        if (value == null) {
            out.writeInt(0);
        } else {
            out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                value[i].writeExternal(out);
            }
        }
    }

    public static JMSXid[] readXidArray(DataInput in) throws IOException {
        int totalLen = in.readInt();
        JMSXid[] objReturn = new JMSXid[totalLen];
        for (int i = 0; i < totalLen; ++i) {
            objReturn[i] = new JMSXid(in);
        }
        return objReturn;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",{");
        b.append(Integer.toHexString(this.getIntegerFlag()));
        b.append("}");
        b.append(",xid list={");
        for (int i = 0; this.xidList != null && i < this.xidList.length; ++i) {
            if (i != 0) {
                b.append(',');
            }
            b.append(this.xidList[i]);
        }
        b.append('}');
        return b.toString();
    }
}

