/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.MessageHandleEvent;

public class SingleMessageHandleEvent
extends MessageHandleEvent {
    private MessageID messageID;

    public SingleMessageHandleEvent(byte opcode, MessageID messageID) {
        super(opcode);
        this.messageID = messageID;
    }

    public SingleMessageHandleEvent(MetaHeader metaHeader, byte opcode) {
        super(metaHeader, opcode);
    }

    public void setMessageID(MessageID messageID) {
        this.messageID = messageID;
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.messageID = new MessageID(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        this.messageID.writeExternal(out);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString()).append(',').append(this.isTransacted() ? "T" : "");
        b.append('{').append(this.messageID).append('}');
        return b.toString();
    }
}

