/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.selector;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.selector.BinaryExpression;
import jeus.jms.common.message.selector.BooleanExpression;
import jeus.jms.common.message.selector.ConstantExpression;
import jeus.jms.common.message.selector.Expression;
import jeus.jms.common.message.selector.LogicExpression;
import jeus.jms.common.message.selector.PropertyExpression;
import jeus.jms.common.message.selector.UnaryExpression;

public abstract class ComparisonExpression
extends BinaryExpression
implements BooleanExpression {
    private static final HashSet REGEXP_CONTROL_CHARS = new HashSet();

    public static BooleanExpression createBetween(Expression value, Expression left, Expression right) {
        return LogicExpression.createAND(ComparisonExpression.createGreaterThanEqual(value, left), ComparisonExpression.createLessThanEqual(value, right));
    }

    public static BooleanExpression createNotBetween(Expression value, Expression left, Expression right) {
        return LogicExpression.createOR(ComparisonExpression.createLessThan(value, left), ComparisonExpression.createGreaterThan(value, right));
    }

    public static BooleanExpression createLike(Expression left, String right, String escape) {
        if (escape != null && escape.length() != 1) {
            throw new RuntimeException("The ESCAPE string litteral is invalid.  It can only be one character.  Litteral used: " + escape);
        }
        int c = -1;
        if (escape != null) {
            c = 0xFFFF & escape.charAt(0);
        }
        return new LikeExpression(left, right, c);
    }

    public static BooleanExpression createNotLike(Expression left, String right, String escape) {
        return UnaryExpression.createNOT(ComparisonExpression.createLike(left, right, escape));
    }

    public static BooleanExpression createInFilter(Expression left, List elements) {
        if (!(left instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression((PropertyExpression)left, elements, false);
    }

    public static BooleanExpression createNotInFilter(Expression left, List elements) {
        if (!(left instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression((PropertyExpression)left, elements, true);
    }

    public static BooleanExpression createIsNull(Expression left) {
        return ComparisonExpression.doCreateEqual(left, ConstantExpression.NULL);
    }

    public static BooleanExpression createIsNotNull(Expression left) {
        return UnaryExpression.createNOT(ComparisonExpression.doCreateEqual(left, ConstantExpression.NULL));
    }

    public static BooleanExpression createNotEqual(Expression left, Expression right) {
        return UnaryExpression.createNOT(ComparisonExpression.createEqual(left, right));
    }

    public static BooleanExpression createEqual(Expression left, Expression right) {
        ComparisonExpression.checkEqualOperand(left);
        ComparisonExpression.checkEqualOperand(right);
        ComparisonExpression.checkEqualOperandCompatability(left, right);
        return ComparisonExpression.doCreateEqual(left, right);
    }

    private static BooleanExpression doCreateEqual(Expression left, Expression right) {
        return new ComparisonExpression(left, right){

            public Object evaluate(UserMessage message) {
                Object rv;
                Object lv = this.left.evaluate(message);
                if (lv == null ^ (rv = this.right.evaluate(message)) == null) {
                    return Boolean.FALSE;
                }
                if (lv == rv || lv.equals(rv)) {
                    return Boolean.TRUE;
                }
                if (lv instanceof Comparable && rv instanceof Comparable) {
                    return this.compare((Comparable)lv, (Comparable)rv);
                }
                return Boolean.FALSE;
            }

            protected boolean asBoolean(int answer) {
                return answer == 0;
            }

            public String getExpressionSymbol() {
                return "=";
            }
        };
    }

    public static BooleanExpression createGreaterThan(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer > 0;
            }

            public String getExpressionSymbol() {
                return ">";
            }
        };
    }

    public static BooleanExpression createGreaterThanEqual(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer >= 0;
            }

            public String getExpressionSymbol() {
                return ">=";
            }
        };
    }

    public static BooleanExpression createLessThan(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer < 0;
            }

            public String getExpressionSymbol() {
                return "<";
            }
        };
    }

    public static BooleanExpression createLessThanEqual(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer <= 0;
            }

            public String getExpressionSymbol() {
                return "<=";
            }
        };
    }

    public static void checkLessThanOperand(Expression expr) {
        if (expr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expr).getValue();
            if (value instanceof Number) {
                return;
            }
            throw new RuntimeException("Value '" + expr + "' cannot be compared.");
        }
        if (expr instanceof BooleanExpression) {
            throw new RuntimeException("Value '" + expr + "' cannot be compared.");
        }
    }

    public static void checkEqualOperand(Expression expr) {
        Object value;
        if (expr instanceof ConstantExpression && (value = ((ConstantExpression)expr).getValue()) == null) {
            throw new RuntimeException("'" + expr + "' cannot be compared.");
        }
    }

    private static void checkEqualOperandCompatability(Expression left, Expression right) {
        if (left instanceof ConstantExpression && right instanceof ConstantExpression && left instanceof BooleanExpression && !(right instanceof BooleanExpression)) {
            throw new RuntimeException("'" + left + "' cannot be compared with '" + right + "'");
        }
    }

    public ComparisonExpression(Expression left, Expression right) {
        super(left, right);
    }

    public Object evaluate(UserMessage message) {
        Comparable lv = (Comparable)this.left.evaluate(message);
        if (lv == null) {
            return null;
        }
        Comparable rv = (Comparable)this.right.evaluate(message);
        if (rv == null) {
            return null;
        }
        return this.compare(lv, rv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Boolean compare(Comparable left, Comparable right) {
        Class<?> rightClass;
        Class<?> leftClass = left.getClass();
        if (leftClass == (rightClass = right.getClass())) return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
        if (leftClass == Byte.class) {
            if (rightClass == Short.class) {
                left = new Short(((Number)((Object)left)).shortValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Integer.class) {
                left = new Integer(((Number)((Object)left)).intValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Long.class) {
                left = new Long(((Number)((Object)left)).longValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Float.class) {
                left = new Float(((Number)((Object)left)).floatValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rightClass != Double.class) return Boolean.FALSE;
                left = new Double(((Number)((Object)left)).doubleValue());
            }
            return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (leftClass == Short.class) {
            if (rightClass == Integer.class) {
                left = new Integer(((Number)((Object)left)).intValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Long.class) {
                left = new Long(((Number)((Object)left)).longValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Float.class) {
                left = new Float(((Number)((Object)left)).floatValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rightClass != Double.class) return Boolean.FALSE;
                left = new Double(((Number)((Object)left)).doubleValue());
            }
            return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (leftClass == Integer.class) {
            if (rightClass == Long.class) {
                left = new Long(((Number)((Object)left)).longValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Float.class) {
                left = new Float(((Number)((Object)left)).floatValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rightClass != Double.class) return Boolean.FALSE;
                left = new Double(((Number)((Object)left)).doubleValue());
            }
            return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (leftClass == Long.class) {
            if (rightClass == Integer.class) {
                right = new Long(((Number)((Object)right)).longValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Float.class) {
                left = new Float(((Number)((Object)left)).floatValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rightClass != Double.class) return Boolean.FALSE;
                left = new Double(((Number)((Object)left)).doubleValue());
            }
            return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (leftClass == Float.class) {
            if (rightClass == Integer.class) {
                right = new Float(((Number)((Object)right)).floatValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Long.class) {
                right = new Float(((Number)((Object)right)).floatValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rightClass != Double.class) return Boolean.FALSE;
                left = new Double(((Number)((Object)left)).doubleValue());
            }
            return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            if (leftClass != Double.class) return Boolean.FALSE;
            if (rightClass == Integer.class) {
                right = new Double(((Number)((Object)right)).doubleValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rightClass == Long.class) {
                right = new Double(((Number)((Object)right)).doubleValue());
                return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rightClass != Float.class) return Boolean.FALSE;
                right = new Float(((Number)((Object)right)).doubleValue());
            }
        }
        return this.asBoolean(left.compareTo(right)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected abstract boolean asBoolean(int var1);

    public boolean matches(UserMessage message) {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    static {
        REGEXP_CONTROL_CHARS.add(new Character('.'));
        REGEXP_CONTROL_CHARS.add(new Character('\\'));
        REGEXP_CONTROL_CHARS.add(new Character('['));
        REGEXP_CONTROL_CHARS.add(new Character(']'));
        REGEXP_CONTROL_CHARS.add(new Character('^'));
        REGEXP_CONTROL_CHARS.add(new Character('$'));
        REGEXP_CONTROL_CHARS.add(new Character('?'));
        REGEXP_CONTROL_CHARS.add(new Character('*'));
        REGEXP_CONTROL_CHARS.add(new Character('+'));
        REGEXP_CONTROL_CHARS.add(new Character('{'));
        REGEXP_CONTROL_CHARS.add(new Character('}'));
        REGEXP_CONTROL_CHARS.add(new Character('|'));
        REGEXP_CONTROL_CHARS.add(new Character('('));
        REGEXP_CONTROL_CHARS.add(new Character(')'));
        REGEXP_CONTROL_CHARS.add(new Character(':'));
        REGEXP_CONTROL_CHARS.add(new Character('&'));
        REGEXP_CONTROL_CHARS.add(new Character('<'));
        REGEXP_CONTROL_CHARS.add(new Character('>'));
        REGEXP_CONTROL_CHARS.add(new Character('='));
        REGEXP_CONTROL_CHARS.add(new Character('!'));
    }

    static class LikeExpression
    extends UnaryExpression
    implements BooleanExpression {
        Pattern likePattern;

        public LikeExpression(Expression right, String like, int escape) {
            super(right);
            StringBuffer regexp = new StringBuffer(like.length() * 2);
            regexp.append("\\A");
            for (int i = 0; i < like.length(); ++i) {
                char c = like.charAt(i);
                if (escape == (0xFFFF & c)) {
                    if (++i >= like.length()) break;
                    char t = like.charAt(i);
                    regexp.append("\\x");
                    regexp.append(Integer.toHexString(0xFFFF & t));
                    continue;
                }
                if (c == '%') {
                    regexp.append(".*?");
                    continue;
                }
                if (c == '_') {
                    regexp.append(".");
                    continue;
                }
                if (REGEXP_CONTROL_CHARS.contains(new Character(c))) {
                    regexp.append("\\x");
                    regexp.append(Integer.toHexString(0xFFFF & c));
                    continue;
                }
                regexp.append(c);
            }
            regexp.append("\\z");
            this.likePattern = Pattern.compile(regexp.toString(), 32);
        }

        public String getExpressionSymbol() {
            return "LIKE";
        }

        public Object evaluate(UserMessage message) {
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return null;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return this.likePattern.matcher((String)rv).matches() ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean matches(UserMessage message) {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

