/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.selector;

import java.util.Map;
import java.util.TimeZone;
import javax.jms.InvalidSelectorException;
import jeus.jms.common.event.Evaluator;
import jeus.jms.common.event.ParamSet;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageProperty;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.selector.BooleanExpression;
import jeus.jms.common.message.selector.grammar.SelectorParser;
import jeus.util.LinkedHashMap;

public class MessageCheck {
    private BooleanExpression selector;
    private Evaluator evaluator;
    private static long GMTCompensated;
    private Map cache;

    public MessageCheck(String messageSelector) throws InvalidSelectorException {
        if (messageSelector == null || messageSelector.equalsIgnoreCase("true") || messageSelector.trim().equals("")) {
            this.selector = null;
        } else {
            try {
                this.evaluator = (Evaluator)Class.forName(messageSelector).newInstance();
            }
            catch (Exception e) {
                this.selector = new SelectorParser().parse(messageSelector);
            }
        }
        this.initCache();
    }

    private void initCache() {
        this.cache = new Cache(2, 10);
    }

    public static boolean isExpired(long expiration) {
        return expiration != 0L && expiration < System.currentTimeMillis() - GMTCompensated;
    }

    public boolean isSelectedMessage(UserMessage message) {
        if (this.evaluator == null && this.selector == null) {
            return true;
        }
        MessageID messageID = message.getMessageID();
        Object cached = this.cache.get(messageID);
        if (cached != null) {
            return (Boolean)cached;
        }
        boolean result = this.evaluator != null ? this.evaluator.evaluate(this.getParamSet(message)) : this.selector.matches(message);
        this.cache.put(messageID, result ? Boolean.TRUE : Boolean.FALSE);
        return result;
    }

    private ParamSet getParamSet(UserMessage message) {
        MessageProperty msgProperties = message.getProperties();
        return new ParamSet(msgProperties);
    }

    static {
        TimeZone time = TimeZone.getDefault();
        GMTCompensated = time.getRawOffset();
    }

    private class Cache
    extends LinkedHashMap {
        private int fixed;

        public Cache(int size, int fixed) {
            super(size);
            this.fixed = fixed;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fixed;
        }
    }
}

