/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.pool;

import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XASession;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.facility.connection.JeusXAConnection;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.client.facility.session.SessionFacility;
import jeus.jms.common.pool.JeusXAServerSession;
import jeus.jms.common.pool.ManagedServerSessionPool;
import jeus.jms.common.pool.SessionPoolManager;

public class JeusXAServerSessionPool
extends JeusXAConnection
implements ManagedServerSessionPool {
    private final SessionPoolManager manager;
    private final LinkedList sessionPool;

    public JeusXAServerSessionPool(JMSServerEntry entry, SessionPoolManager manager, String clientID, boolean fixed, int type) {
        super(entry, clientID, fixed, type);
        this.manager = manager;
        this.sessionPool = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        this.checkPoolResource();
        LinkedList linkedList = this.sessionPool;
        synchronized (linkedList) {
            while (this.sessionPool.isEmpty()) {
                try {
                    this.sessionPool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (ServerSession)this.sessionPool.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerSession peekServerSession() {
        LinkedList linkedList = this.sessionPool;
        synchronized (linkedList) {
            if (this.sessionPool.isEmpty()) {
                return null;
            }
            return (ServerSession)this.sessionPool.removeFirst();
        }
    }

    private void checkPoolResource() {
        if (this.sessionPool.isEmpty()) {
            this.manager.sessionEmpty();
        }
    }

    public void createSession(int count) {
        for (int i = 0; i < count; ++i) {
            new Thread(new SessionCreator()).start();
        }
    }

    public void createThread(int count) {
    }

    public void threadRemoved() {
        this.closeSurplusSession();
    }

    public void workStarted(XASession session) {
        this.manager.workStarted((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workCompleted(XASession session) {
        if (!(session instanceof JeusXAServerSession)) {
            return;
        }
        this.manager.workCompleted((Session)session);
        LinkedList linkedList = this.sessionPool;
        synchronized (linkedList) {
            this.sessionPool.add(session);
            this.sessionPool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(int sessionID, XASession session) {
        LinkedList linkedList = this.sessionPool;
        synchronized (linkedList) {
            this.sessionPool.add(new JeusXAServerSession(session));
            this.sessionPool.notify();
        }
        super.registerSession(sessionID, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSession(int sessionID) {
        SessionFacility resource = null;
        try {
            resource = this.getSessionFacility(sessionID);
        }
        catch (JMSException e) {
            return;
        }
        if (resource instanceof JeusSession) {
            LinkedList linkedList = this.sessionPool;
            synchronized (linkedList) {
                this.sessionPool.remove(resource);
            }
        }
        super.unregisterSession(sessionID);
    }

    private void closeSurplusSession() {
    }

    private void closeSession(ServerSession server) {
        try {
            Session session = server.getSession();
            session.close();
            this.manager.sessionClosed();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private class SessionCreator
    implements Runnable {
        private SessionCreator() {
        }

        public void run() {
            try {
                XASession session = JeusXAServerSessionPool.this.createXASession();
                JeusXAServerSessionPool.this.manager.sessionCreated((Session)session);
            }
            catch (JMSException e) {
                e.printStackTrace();
                JeusXAServerSessionPool.this.manager.failed();
            }
        }
    }
}

