/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import jeus.jms.common.util.ProtocolUtil;
import jeus.nio.ByteBufferWrapper;

public abstract class BufferOutputStream
extends OutputStream
implements DataOutput {
    protected ByteBufferWrapper buffer;

    public BufferOutputStream(int initial, boolean direct) {
        this.buffer = direct ? ByteBufferWrapper.allocateDirect(initial) : ByteBufferWrapper.allocate(initial);
    }

    public BufferOutputStream(ByteBufferWrapper buffer) {
        this.buffer = buffer;
    }

    public ByteBufferWrapper getBuffer() {
        return this.buffer;
    }

    public void write(ByteBufferWrapper write) throws IOException {
        this.reserve(write.remaining());
        this.buffer.put(write);
    }

    public void writeDouble(double v) throws IOException {
        this.reserve(8);
        this.buffer.putDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.reserve(4);
        this.buffer.putFloat(v);
    }

    public void write(int b) throws IOException {
        this.reserve(1);
        this.buffer.put((byte)b);
    }

    public void writeByte(int v) throws IOException {
        this.reserve(1);
        this.buffer.put((byte)v);
    }

    public void writeChar(int v) throws IOException {
        this.reserve(2);
        this.buffer.putChar((char)v);
    }

    public void writeInt(int v) throws IOException {
        this.reserve(4);
        this.buffer.putInt(v);
    }

    public void writeShort(int v) throws IOException {
        this.reserve(2);
        this.buffer.putShort((short)v);
    }

    public void writeLong(long v) throws IOException {
        this.reserve(8);
        this.buffer.putLong(v);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.reserve(1);
        this.buffer.put((byte)(v ? 1 : 0));
    }

    public void write(byte[] bs, int off, int len) throws IOException {
        this.reserve(len);
        if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buffer.put(bs, off, len);
    }

    public void writeBytes(String s) throws IOException {
        this.reserve(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.put((byte)s.charAt(i));
        }
    }

    public void writeChars(String s) throws IOException {
        this.reserve(s.length() << 1);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buffer.put((byte)(v >>> 8 & 0xFF));
            this.buffer.put((byte)(v & 0xFF));
        }
    }

    public void writeUTF(String str) throws IOException {
        ProtocolUtil.writeUTF(str, this);
    }

    protected abstract void reserve(int var1) throws IOException;
}

