/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jeus.jms.common.util.SqueezeAdaptor;

public class DataSqueezer {
    private static final String NULL_PREFIX = "X";
    private static final int ARRAY_SIZE = 90;
    private static final int FIRST_ADAPTOR_OFFSET = 33;
    private SqueezeAdaptor[] _adaptorByPrefix = new SqueezeAdaptor[90];
    private Map _adaptors = new HashMap();

    public void setSqueezeAdaptors(List adaptors) {
        for (SqueezeAdaptor adaptor : adaptors) {
            this.register(adaptor);
        }
    }

    public synchronized void register(SqueezeAdaptor adaptor) {
        if (adaptor == null) {
            throw new IllegalArgumentException("null-adaptor");
        }
        String prefix = adaptor.getPrefix();
        int prefixLength = prefix.length();
        if (prefixLength < 1) {
            throw new IllegalArgumentException("short-prefix");
        }
        Class dataClass = adaptor.getDataClass();
        if (dataClass == null) {
            throw new IllegalArgumentException("null-class");
        }
        for (int i = 0; i < prefixLength; ++i) {
            char ch = prefix.charAt(i);
            if (ch < '!' | ch > 'z') {
                throw new IllegalArgumentException("prefix-out-of-range");
            }
            int offset = ch - 33;
            if (this._adaptorByPrefix[offset] != null) {
                throw new IllegalArgumentException("adaptor-prefix-taken" + prefix.substring(i, i));
            }
            this._adaptorByPrefix[offset] = adaptor;
        }
        this._adaptors.put(dataClass, adaptor);
    }

    public String squeeze(Object data) {
        if (data == null) {
            return NULL_PREFIX;
        }
        SqueezeAdaptor adaptor = (SqueezeAdaptor)this._adaptors.get(data.getClass());
        return adaptor.squeeze(this, data);
    }

    public String[] squeeze(Object[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.squeeze(data[i]);
        }
        return result;
    }

    public Object unsqueeze(String string) {
        SqueezeAdaptor adaptor = null;
        if (string.equals(NULL_PREFIX)) {
            return null;
        }
        int offset = string.charAt(0) - 33;
        if (offset >= 0 && offset < this._adaptorByPrefix.length) {
            adaptor = this._adaptorByPrefix[offset];
        }
        if (adaptor == null) {
            return string;
        }
        return adaptor.unsqueeze(this, string);
    }

    public Object[] unsqueeze(String[] strings) {
        if (strings == null) {
            return null;
        }
        int length = strings.length;
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.unsqueeze(strings[i]);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSqueezer[adaptors=<");
        buffer.append(this._adaptors.toString());
        buffer.append(">]");
        return buffer.toString();
    }
}

