/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.JMSRequest;
import jeus.jms.common.util.MessageHandler;

public class JMSAsyncRequest
implements JMSRequest {
    private final MessageHandler handler;
    private final int observerID;

    public JMSAsyncRequest(MessageHandler handler, int observerID) {
        this.handler = handler;
        this.observerID = observerID;
    }

    public boolean messageArrived(MessageContainer packet) {
        try {
            this.handler.handleMessage(packet);
        }
        catch (JMSException e) {
            packet.setObserverID(this.observerID);
            this.handler.handleException(packet, e);
            return false;
        }
        return true;
    }

    public boolean messageFailed(MessageContainer packet, JMSException ex) {
        this.handler.handleException(packet, ex);
        return true;
    }

    public boolean isArrived() {
        return false;
    }

    public void cancelByException(JMSException ex) {
    }

    public void cancel() {
    }

    public String toString() {
        return "CB:" + this.observerID + ":" + this.handler;
    }
}

