/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TransactionInProgressException;
import jeus.util.ErrorMsgManager;

public final class JMSExceptionFactory {
    public static final int JMS_EXCEPTION = 0;
    public static final int ILLEGAL_STATE_EXCEPTION = 1;
    public static final int TRANSACTION_IN_PROGRESS_EXCEPTION = 2;
    public static final int INVALID_DESTINATION_EXCEPTION = 3;
    public static final int INVALID_SELECTOR_EXCEPTION = 4;
    public static final int MESSAGE_NOT_READABLE_EXCEPTION = 5;
    public static final int MESSAGE_NOT_WRITEABLE_EXCEPTION = 6;
    public static final int MESSAGE_EOF_EXCEPTION = 7;
    public static final int MESSAGE_FORMAT_EXCEPTION = 8;
    public static final int INVALID_CLIENT_ID_EXCEPTION = 9;
    public static final int MESSAGE_EXPIRED = 10;
    public static final int REQUEST_TIMEOUT = 100;

    public static JMSException createJMSException(String message, Exception linked) {
        if (linked instanceof JMSException) {
            return (JMSException)((Object)linked);
        }
        JMSException e = new JMSException(message);
        e.setLinkedException(linked);
        return e;
    }

    public static JMSException createJMSException(Exception linked) {
        return JMSExceptionFactory.createJMSException(linked.getMessage(), linked);
    }

    public static JMSException createJMSException(int errorCode) {
        String message = ErrorMsgManager.getLocalizedString((int)errorCode);
        return new JMSException(message);
    }

    public static JMSException createJMSException(int errorCode, int exceptionType) {
        return JMSExceptionFactory.createJMSException(errorCode, null, null, exceptionType);
    }

    public static JMSException createJMSException(int errorCode, Object par) {
        return JMSExceptionFactory.createJMSException(errorCode, par, null);
    }

    public static JMSException createJMSException(int errorCode, Exception e) {
        return JMSExceptionFactory.createJMSException(errorCode, null, e);
    }

    public static JMSException createJMSException(int errorCode, Object par, int exceptionType) {
        return JMSExceptionFactory.createJMSException(errorCode, par, null, exceptionType);
    }

    public static JMSException createJMSException(int errorCode, Object par, Exception linkedException) {
        String reason = par == null ? ErrorMsgManager.getLocalizedString((int)errorCode) : ErrorMsgManager.getLocalizedString((int)errorCode, (Object)par);
        String errorCode2 = JMSExceptionFactory.getErrorCode(errorCode);
        JMSException e = new JMSException(reason, errorCode2);
        if (linkedException != null) {
            e.setLinkedException(linkedException);
        }
        return e;
    }

    public static JMSException createJMSException(int errorCode, Object par, Exception linkedException, int type) {
        String reason = par == null ? ErrorMsgManager.getLocalizedString((int)errorCode) : ErrorMsgManager.getLocalizedString((int)errorCode, (Object)par);
        String errorCode2 = JMSExceptionFactory.getErrorCode(errorCode);
        return JMSExceptionFactory.createJMSException(reason, errorCode2, type, linkedException);
    }

    public static JMSException createJMSException(String reason, String errorCode, int exceptionType, Exception linkedException) {
        Object e;
        switch (exceptionType) {
            case 1: {
                e = new IllegalStateException(reason, errorCode);
                break;
            }
            case 2: {
                e = new TransactionInProgressException(reason, errorCode);
                break;
            }
            case 3: {
                e = new InvalidDestinationException(reason, errorCode);
                break;
            }
            case 4: {
                e = new InvalidSelectorException(reason, errorCode);
                break;
            }
            case 5: {
                e = new MessageNotReadableException(reason, errorCode);
                break;
            }
            case 6: {
                e = new MessageNotWriteableException(reason, errorCode);
                break;
            }
            case 7: {
                e = new MessageEOFException(reason, errorCode);
                break;
            }
            case 8: {
                e = new MessageFormatException(reason, errorCode);
                break;
            }
            case 9: {
                e = new InvalidClientIDException(reason, errorCode);
                break;
            }
            default: {
                e = new JMSException(reason, errorCode);
            }
        }
        e.setLinkedException(linkedException);
        return e;
    }

    public static JMSException createJMSException(int errorCode, Object[] par) {
        return JMSExceptionFactory.createJMSException(errorCode, par, null);
    }

    public static JMSException createJMSException(int errorCode, Object[] par, Exception linkedException) {
        String reason = par == null ? ErrorMsgManager.getLocalizedString((int)errorCode) : ErrorMsgManager.getLocalizedString((int)errorCode, (Object[])par);
        String errorCode2 = JMSExceptionFactory.getErrorCode(errorCode);
        JMSException e = new JMSException(reason, errorCode2);
        if (linkedException != null) {
            e.setLinkedException(linkedException);
        }
        return e;
    }

    public static int getExceptionCode(Exception ex) {
        if (ex instanceof IllegalStateException) {
            return 1;
        }
        if (ex instanceof TransactionInProgressException) {
            return 2;
        }
        if (ex instanceof InvalidDestinationException) {
            return 3;
        }
        if (ex instanceof InvalidSelectorException) {
            return 4;
        }
        if (ex instanceof MessageNotReadableException) {
            return 5;
        }
        if (ex instanceof MessageNotWriteableException) {
            return 6;
        }
        if (ex instanceof MessageEOFException) {
            return 7;
        }
        if (ex instanceof MessageFormatException) {
            return 8;
        }
        if (ex instanceof InvalidClientIDException) {
            return 9;
        }
        if (ex instanceof JMSException) {
            return 0;
        }
        return 0;
    }

    private static String getErrorCode(int errorCode) {
        return "[TMQ-" + errorCode + "]";
    }
}

