/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSRequest;

public class JMSRequestManager {
    private Map observers;
    private BoundedInteger sequence = BoundedInteger.getIncrementor();

    public JMSRequestManager() {
        this.observers = new HashMap();
    }

    public int getNextObserverID() {
        return this.sequence.getNextValue();
    }

    public synchronized void registerObserver(int observerID, JMSRequest request) {
        this.observers.put(new Integer(observerID), request);
    }

    public synchronized JMSRequest removeObserver(int observerID) {
        return (JMSRequest)this.observers.remove(new Integer(observerID));
    }

    public synchronized boolean isValidRequest(int observerID) {
        return this.observers.containsKey(new Integer(observerID));
    }

    public synchronized void cancelObserver(int observerID) {
        this.cancelObserver(new Integer(observerID));
    }

    public synchronized void cancelObserver(Integer observerID) {
        JMSRequest request = (JMSRequest)this.observers.remove(observerID);
        if (request != null) {
            request.cancel();
        }
    }

    public synchronized void cancelObservers(Collection obsevers) {
        Iterator it = obsevers.iterator();
        while (it.hasNext()) {
            this.cancelObserver((Integer)it.next());
        }
    }

    public synchronized void cancelObserverByException(Integer observerID, JMSException ex) {
        JMSRequest request = (JMSRequest)this.observers.remove(observerID);
        if (request != null) {
            request.cancelByException(ex);
        }
    }

    public synchronized void cancelObserversByException(Collection obsevers, JMSException ex) {
        Iterator it = obsevers.iterator();
        while (it.hasNext()) {
            this.cancelObserverByException((Integer)it.next(), ex);
        }
    }

    public synchronized void cancelObserversByException(JMSException ex) {
        Iterator it = this.observers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JMSRequest request = (JMSRequest)entry.getValue();
            it.remove();
            if (request == null) continue;
            request.cancelByException(ex);
        }
    }

    public synchronized void cancelObservers() {
        for (JMSRequest request : this.observers.values()) {
            request.cancel();
        }
        this.observers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map removeAll() {
        try {
            Map map = this.getAll();
            return map;
        }
        finally {
            this.observers.clear();
        }
    }

    public synchronized Map getAll() {
        return new HashMap(this.observers);
    }
}

