/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSRequest;
import jeus.jms.common.util.Timer;

public class JMSSyncRequest
implements JMSRequest {
    private boolean canceled;
    private int observerID;
    private JMSException ex;
    private MessageContainer packet;

    public JMSSyncRequest() {
    }

    public JMSSyncRequest(int observerID) {
        this.observerID = observerID;
    }

    public int getObserverID() {
        return this.observerID;
    }

    public synchronized MessageContainer waitReply(long timeout) {
        Timer timer = new Timer(timeout);
        try {
            timer.start(timeout < 0L ? 2000L : timeout);
            while (!this.canceled && !this.isArrived() && timer.remaining() > 0L) {
                this.wait(timer.remaining());
                timer.elapsed();
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return this.packet;
    }

    public synchronized MessageContainer waitResult(long timeout) throws JMSException {
        MessageContainer result = this.waitReply(timeout);
        if (this.ex != null) {
            throw JMSExceptionFactory.createJMSException("Exception occurred while waiting reply", (Exception)((Object)this.ex));
        }
        return result;
    }

    public synchronized boolean messageReady(MessageContainer packet) {
        this.packet = packet;
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean messageArrived(MessageContainer packet) {
        boolean bl;
        try {
            bl = !this.canceled;
            this.packet = this.canceled ? this.packet : packet;
        }
        catch (Throwable throwable) {
            this.packet = this.canceled ? this.packet : packet;
            this.canceled = true;
            this.notifyAll();
            throw throwable;
        }
        this.canceled = true;
        this.notifyAll();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean messageFailed(MessageContainer packet, JMSException ex) {
        boolean bl;
        try {
            bl = this.canceled;
            this.ex = this.canceled ? this.ex : ex;
        }
        catch (Throwable throwable) {
            this.ex = this.canceled ? this.ex : ex;
            this.canceled = true;
            this.notifyAll();
            throw throwable;
        }
        this.canceled = true;
        this.notifyAll();
        return bl;
    }

    public synchronized void cancelByException(JMSException ex) {
        this.ex = ex;
        this.cancel();
    }

    public synchronized void cancel() {
        this.canceled = true;
        this.notifyAll();
    }

    public boolean isArrived() {
        return this.packet != null;
    }

    public int hashcode() {
        return this.observerID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JMSSyncRequest)) {
            return false;
        }
        JMSSyncRequest another = (JMSSyncRequest)obj;
        return this.observerID == another.observerID;
    }

    public String toString() {
        return "SYNC:" + this.observerID + (this.isArrived() ? ":" + this.packet : ":--");
    }
}

