/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.transaction.xa.Xid;
import jeus.jms.common.message.ISerializable;
import jeus.transaction.XidImpl;
import jeus.transaction.util.XidToString;

public class JMSXid
extends XidImpl
implements Xid,
ISerializable {
    private transient Integer gtidHashCode;
    private transient Xid xid;

    public JMSXid(DataInput in) throws IOException {
        this.readExternal(in);
    }

    public JMSXid(byte[] data) throws IOException {
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(data));
        this.readExternal(dataIn);
    }

    public JMSXid(Xid xid) {
        super(xid);
        this.xid = xid;
        this.gtidHashCode = this.getHashCode(this.getGlobalTransactionId());
    }

    private Integer getHashCode(byte[] gtid) {
        int hash = 0;
        for (int i = 0; i < gtid.length; ++i) {
            hash = hash * 37 + gtid[i];
        }
        return new Integer(hash);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.getFormatId());
        byte[] gtid = this.getGlobalTransactionId();
        out.writeByte(gtid.length);
        out.write(gtid);
        byte[] bq = this.getBranchQualifier();
        out.writeByte(bq.length);
        out.write(bq);
    }

    public void readExternal(DataInput in) throws IOException {
        int formatId = in.readInt();
        byte[] gtid = new byte[in.readByte()];
        in.readFully(gtid);
        byte[] bq = new byte[in.readByte()];
        in.readFully(bq);
        this.setXid(gtid, bq, formatId);
        this.gtidHashCode = this.getHashCode(gtid);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(outputStream);
        this.writeExternal(dataOut);
        return outputStream.toByteArray();
    }

    public Integer getGtIdHashCode() {
        return this.gtidHashCode;
    }

    public Xid getSourceXid() {
        return this.xid;
    }

    public int hashCode() {
        return XidToString.getXidString((Xid)this).hashCode();
    }
}

