/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jeus.util.Serializer;

public class ProtocolUtil {
    private static final byte VALID_MASK = 0;
    private static final byte NULL_MASK = 1;
    private static final byte ZERO_LENGTH_MASK = 2;
    private static final int CHAR_BUF_SIZE = 256;
    private static char[] cbuf = new char[256];

    public static String readString(DataInput in) throws IOException {
        byte flag = in.readByte();
        switch (flag) {
            case 1: {
                return null;
            }
            case 2: {
                return "";
            }
            case 0: {
                return in.readUTF();
            }
        }
        throw new RuntimeException("Invalid mask");
    }

    public static void writeString(String value, DataOutput out) throws IOException {
        if (value == null) {
            out.writeByte(1);
        } else if (value.length() == 0) {
            out.writeByte(2);
        } else {
            out.writeByte(0);
            out.writeUTF(value);
        }
    }

    public static String readStringLong(DataInput in) throws IOException {
        byte flag = in.readByte();
        if ((flag & 1) != 0) {
            return null;
        }
        if ((flag & 2) != 0) {
            return "";
        }
        return ProtocolUtil.readUTFLong(in);
    }

    public static void writeStringLong(String value, DataOutput out) throws IOException {
        if (value == null) {
            out.writeByte(1);
        } else if (value.length() == 0) {
            out.writeByte(2);
        } else {
            out.writeByte(0);
            ProtocolUtil.writeUTFLong(value, out);
        }
    }

    public static String readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }

    public static String readUTFLong(DataInput in) throws IOException {
        int utflen = in.readInt();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }

    public static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c & 0x3F);
        }
        out.write(bytearr);
        return utflen + 2;
    }

    public static int writeUTFLong(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen + 4];
        bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c & 0x3F);
        }
        out.write(bytearr);
        return utflen + 4;
    }

    public static int getUTFLength(String s) {
        int csize;
        int len = s.length();
        int utflen = 0;
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, 256);
            s.getChars(off, off + csize, cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = cbuf[cpos];
                utflen += ProtocolUtil.getCharLength(c);
            }
        }
        return utflen;
    }

    public static int getCharLength(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c > '\u07ff') {
            return 3;
        }
        return 2;
    }

    public static byte[] readBytes(DataInput in) throws IOException {
        byte flag = in.readByte();
        switch (flag) {
            case 1: {
                return null;
            }
            case 2: {
                return new byte[0];
            }
            case 0: {
                int len = in.readInt();
                byte[] b = new byte[len];
                in.readFully(b);
                return b;
            }
        }
        throw new IOException("invalid mask : " + flag);
    }

    public static void writeBytes(byte[] value, DataOutput out) throws IOException {
        ProtocolUtil.writeBytes(value, 0, value.length, out);
    }

    public static void writeBytes(byte[] value, int offset, int length, DataOutput out) throws IOException {
        if (value == null) {
            out.writeByte(1);
        } else if (length == 0) {
            out.writeByte(2);
        } else {
            out.writeByte(0);
            out.writeInt(length);
            out.write(value, offset, length);
        }
    }

    public static void writeObject(Object value, DataOutput out) throws IOException {
        if (value == null) {
            out.writeByte(1);
        } else {
            byte[] buf = new Serializer().serialize(value);
            ProtocolUtil.writeBytes(buf, out);
        }
    }

    public static Object readObject(DataInput in) throws IOException {
        byte[] b = ProtocolUtil.readBytes(in);
        if (b == null) {
            return null;
        }
        if (b.length == 0) {
            return b;
        }
        return new Serializer().deserialize(b);
    }

    public static void writeStringList(List v, DataOutput out) throws IOException {
        if (v == null) {
            out.writeInt(0);
        } else {
            out.writeInt(v.size());
            for (String x : v) {
                ProtocolUtil.writeString(x, out);
            }
        }
    }

    public static List readStringList(DataInput in) throws IOException {
        int size = in.readInt();
        if (size <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(ProtocolUtil.readString(in));
        }
        return list;
    }
}

