/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.SerialExecutionQueue;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public abstract class SerialExecutable
extends SerialExecutionQueue {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public void run() {
        boolean completed;
        this.worksStarted();
        MessageContainer packet = this.getMessage();
        while (packet != null && (completed = this.startWork(packet))) {
            packet = this.getMessage();
        }
        this.worksCompleted();
    }

    public void worksStarted() {
    }

    private boolean startWork(MessageContainer packet) {
        this.preExecution(packet);
        try {
            this.execute(packet);
        }
        catch (JMSException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1171_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1171_LEVEL, JeusMessage_JMS1._1171, (Object)new Object[]{packet, e}, (Throwable)e);
            }
            this.exception(packet, e);
        }
        catch (Throwable t) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1172_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1172_LEVEL, JeusMessage_JMS1._1172, (Object)new Object[]{packet, t}, t);
            }
            this.failed(packet, t);
        }
        return this.postExecution(packet);
    }

    public void preExecution(MessageContainer packet) {
    }

    public abstract void execute(MessageContainer var1) throws Exception;

    public boolean postExecution(MessageContainer packet) {
        return true;
    }

    public void exception(MessageContainer packet, JMSException e) {
    }

    public void failed(MessageContainer packet, Throwable t) {
    }

    public void worksCompleted() {
    }
}

