/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.util.Collection;
import java.util.LinkedList;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.ISerialExecutable;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public abstract class SerialExecutionQueue
implements ISerialExecutable {
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private boolean suspend;
    private boolean executing;
    private Thread executingThread;
    private MessageContainer initialWork;
    private final LinkedList works = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.getAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList removeWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            LinkedList linkedList2;
            try {
                linkedList2 = new LinkedList(this.getAll());
                this.works.clear();
            }
            catch (Throwable throwable) {
                this.works.clear();
                throw throwable;
            }
            return linkedList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(MessageContainer packet) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.initialWork == packet) {
                this.initialWork = null;
            } else {
                this.works.remove(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList getAll() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.initialWork != null) {
                this.works.addFirst(this.initialWork);
                this.initialWork = null;
            }
            return this.works;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueFirst(MessageContainer packet) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.initialWork == null) {
                this.initialWork = packet;
            } else {
                this.works.addFirst(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueFirst(Collection packets) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.initialWork != null) {
                this.works.addFirst(this.initialWork);
                this.initialWork = null;
            }
            this.works.addAll(0, packets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueLast(MessageContainer packet) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.checkEmpty()) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1201_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS1._1201_LEVEL, JeusMessage_JMS1._1201, new Object[]{packet, this, this.executing, this.executingThread});
                }
                this.initialWork = packet;
            } else {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1202_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS1._1202_LEVEL, JeusMessage_JMS1._1202, new Object[]{packet, this, new Integer(this.works.size()), this.executing, this.executingThread});
                }
                this.works.addLast(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueLast(Collection packets) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.initialWork != null) {
                this.works.addFirst(this.initialWork);
                this.initialWork = null;
            }
            this.works.addAll(packets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkEmpty() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.initialWork == null && this.works.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.works.size() + (this.initialWork == null ? 0 : 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.checkEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.initialWork = null;
            this.works.clear();
            this.works.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(boolean suspend) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.suspend = suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(MessageContainer packet) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueLast(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWorks(Collection collection) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueLast(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageContainer dequeueWork() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.dequeueFirst();
        }
    }

    public boolean delegate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExecutor() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return !this.suspend && !this.checkEmpty() && this.checkExecution(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecuting() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.executing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecuting(boolean execute) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.executing = execute;
        }
    }

    public void startExecution(MessageContainer packet) {
        this.enqueueWork(packet);
        this.startExecution();
    }

    public void startExecution() {
        if (this.checkExecutor()) {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(MessageContainer packet) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueFirst(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Collection packets) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.enqueueFirst(packets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuedWorks() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            return this.works.size();
        }
    }

    private boolean checkExecution(boolean assume, boolean newValue) {
        if (this.executing != assume) {
            return false;
        }
        this.executing = newValue;
        this.executingThread = this.executing ? Thread.currentThread() : null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageContainer getFirstMessage() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            MessageContainer packet = this.suspend ? null : this.dequeueFirst();
            boolean bl = this.executing = packet != null;
            if (!this.executing) {
                this.executionReleased();
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1203_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1203_LEVEL, JeusMessage_JMS1._1203, new Object[]{this, packet, this.executing, this.executingThread});
            }
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageContainer dequeueFirst() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.initialWork != null) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1204_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS1._1204_LEVEL, JeusMessage_JMS1._1204, new Object[]{this, this.executing, this.executingThread});
                }
                MessageContainer packet = this.initialWork;
                this.initialWork = null;
                return packet;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1205_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1205_LEVEL, JeusMessage_JMS1._1205, new Object[]{this, this.executing, this.executingThread});
            }
            return !this.works.isEmpty() ? (MessageContainer)this.works.removeFirst() : null;
        }
    }

    protected final MessageContainer getMessage() {
        return this.getFirstMessage();
    }

    public void executionReleased() {
        this.executingThread = null;
    }

    public Thread getExecutingThread() {
        return this.executingThread;
    }
}

