/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import jeus.jms.client.util.ClientSerialExecutable;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.ISerialExecutable;
import jeus.jms.common.util.SerialExecutionQueue;
import jeus.util.concurrent50.concurrent.Executor;

public class SerialExecutor {
    protected final Executor executor;

    public SerialExecutor(Executor executor) {
        this.executor = executor;
    }

    public void execute(Runnable work) throws InterruptedException {
        this.executor.execute(work);
    }

    public void executeForced(Runnable work) {
        this.executor.execute(work);
    }

    public void execute(ISerialExecutable container) {
        this.execute(container, true);
    }

    public void execute(ISerialExecutable container, boolean delegated) {
        if (delegated) {
            this.executeDelegate(container);
        } else {
            this.executeDirect(container);
        }
    }

    public void execute(ClientSerialExecutable container, ClientMessage message) {
        container.enqueueWork(message);
        this.execute((ISerialExecutable)container, container.delegate());
    }

    public void execute(SerialExecutionQueue container, MessageContainer packet) {
        container.enqueueWork(packet);
        this.execute((ISerialExecutable)container, container.delegate());
    }

    public void executeDelegate(ISerialExecutable container) {
        if (container.checkExecutor()) {
            this.executor.execute((Runnable)container);
        }
    }

    public void executeDirect(ISerialExecutable container) {
        if (container.checkExecutor()) {
            container.run();
        }
    }

    public void shutdown() {
    }

    public Executor getPooledExecutor() {
        return this.executor;
    }
}

