/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;

public class Utility {
    private static final int DUMP_MAX = 256;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '%', '&'};

    public static String getDump(byte[] bytes) {
        return Utility.getDump(bytes, 0, bytes.length, " ", "\n");
    }

    public static String getDump(byte[] bytes, int length) {
        return Utility.getDump(bytes, 0, length, " ", "\n");
    }

    public static String getDump(byte[] bytes, int offset, int length) {
        return Utility.getDump(bytes, offset, length, " ", "\n");
    }

    public static String getDump(ByteArray byteArray) {
        return Utility.getDump(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
    }

    public static String getDump(byte[] bytes, int offset, int length, String separator, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < Math.min(bytes.length, offset + length); ++i) {
            String str = Integer.toHexString(bytes[i] & 0xFF);
            buf.append(str.length() == 1 ? "0" : "").append(str).append(separator);
            if ((i - offset) % 32 != 31) continue;
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public static String getRawDump(byte[] bytes) {
        return Utility.getRawDump(bytes, 0, bytes.length);
    }

    private static String getRawDump(byte[] bytes, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < Math.min(bytes.length, offset + length); ++i) {
            String str = Integer.toHexString(bytes[i] & 0xFF);
            buf.append(str.length() == 1 ? "0" : "").append(str).append(' ');
        }
        return buf.toString();
    }

    public static String getDump(ByteBufferWrapper buffer, boolean outflow) {
        int index = 0;
        StringBuffer buf = new StringBuffer();
        int start = outflow ? buffer.position() : 0;
        int end = outflow ? buffer.limit() : buffer.position();
        int i = start;
        while (i < end) {
            String str = Integer.toHexString(buffer.get(i) & 0xFF);
            buf.append(str.length() == 1 ? "0" : "").append(str).append(" ");
            if (index % 32 == 31) {
                buf.append("\n");
            }
            ++i;
            ++index;
        }
        return buf.toString();
    }

    public static String getDump(ByteBufferWrapper[] buffer, boolean outflow) {
        StringBuffer buf = new StringBuffer();
        int index = 0;
        for (int j = 0; j < buffer.length; ++j) {
            int start = outflow ? buffer[j].position() : 0;
            int end = outflow ? buffer[j].limit() : buffer[j].position();
            int i = start;
            while (i < end) {
                String str = Integer.toHexString(buffer[j].get(i) & 0xFF);
                buf.append(str.length() == 1 ? "0" : "").append(str).append(" ");
                if (index % 32 == 31) {
                    buf.append("\n");
                }
                ++i;
                ++index;
            }
        }
        return buf.toString();
    }

    public static String getDump(ByteBufferWrapper buffer, int limit) {
        return Utility.getDump(buffer, 0, limit);
    }

    public static String getDump(ByteBufferWrapper buffer, int offset, int limit) {
        limit = Math.min(offset + 256, limit);
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < limit; ++i) {
            String str = Integer.toHexString(buffer.get(i) & 0xFF);
            buf.append(str.length() == 1 ? "0" : "").append(str).append(' ');
            if (i == limit - 1 || (i - offset) % 32 != 31) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String getAsciiDump(byte[] bytes, int offset, int length) {
        int i;
        StringBuffer buffer = new StringBuffer(256);
        StringBuffer ascii = new StringBuffer(16);
        int to = Math.min(length, 256);
        for (i = 0; i < to; ++i) {
            char c;
            byte b = bytes[i + offset];
            String value = Integer.toHexString(b & 0xFF);
            if (value.length() == 1) {
                buffer.append('0');
            }
            if (Character.isDefined(c = (char)b)) {
                ascii.append(c);
            } else {
                ascii.append('-');
            }
            buffer.append(value).append(' ');
            if (i % 32 != 31) continue;
            buffer.append('\t').append(ascii.toString());
            ascii = new StringBuffer(16);
            if (i == to - 1) continue;
            buffer.append("\n");
        }
        for (i = 0; i < 32 - (to - 1) % 32; ++i) {
            buffer.append("   ");
        }
        buffer.append('\t').append(ascii.toString());
        return buffer.toString();
    }

    public static String toUnsignedString(long value, int shift) {
        char[] buf = new char[64];
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(value & mask)];
        } while ((value >>>= shift) != 0L);
        return new String(buf, charPos, 64 - charPos);
    }
}

