/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console;

import java.io.IOException;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.SecurityUtil;
import jeus.util.StringUtil;

public class JMSCommander {
    private static final String[] TARGET_CONTAINERS = new String[]{"default", "container1"};
    private String engineName;
    private MEJBUtility utility;
    private JMSResourceMBean jmsMbean;

    public JMSCommander(String engineName) {
        this.engineName = engineName;
    }

    public void login(String userName, String password) throws JMSException, IllegalJeusSystemNameException {
        String host = StringUtil.getNodeNameFromEngineName((String)this.engineName);
        SecurityUtil.installClientSecurity((String)host);
        try {
            LoginService.login((Subject)Subject.makeSubject((String)"SYSTEM_DOMAIN", (String)userName, (String)password));
        }
        catch (ServiceException ex) {
            throw JMSExceptionFactory.createJMSException("failed to login.", (Exception)((Object)ex));
        }
        catch (SecurityException ex) {
            throw JMSExceptionFactory.createJMSException("failed to login.", (Exception)((Object)ex));
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", host);
        env.put("java.naming.factory.initial", "jeus.jndi.JEUSContextFactory");
        try {
            this.utility = MEJBUtility.getMEJBUtility(env);
        }
        catch (JMXManagerException ex) {
            JMSException e = new JMSException("JMX Exception");
            e.setLinkedException((Exception)((Object)ex));
            throw e;
        }
        this.init();
    }

    public void logout() throws JMSException {
        try {
            LoginService.logout();
        }
        catch (ServiceException ex) {
            throw JMSExceptionFactory.createJMSException("failed to logout.", (Exception)((Object)ex));
        }
        catch (SecurityException ex) {
            throw JMSExceptionFactory.createJMSException("failed to logout.", (Exception)((Object)ex));
        }
    }

    private void init() throws IllegalJeusSystemNameException {
        String hostName = StringUtil.getNodeNameFromEngineName((String)this.engineName);
        String[] target_node_containers = new String[TARGET_CONTAINERS.length];
        for (int i = 0; i < TARGET_CONTAINERS.length; ++i) {
            target_node_containers[i] = hostName + "_" + TARGET_CONTAINERS[i];
        }
        block3: for (int k = 0; k < target_node_containers.length; ++k) {
            ObjectName[] jmsResources;
            String s = target_node_containers[k];
            try {
                jmsResources = JMXUtility.queryMBean((MBeanServerConnection)this.utility, (String)s, (String)"JMSResource", null, (String)this.engineName, null, null);
            }
            catch (IOException e) {
                continue;
            }
            if (jmsResources == null) continue;
            for (int i = 0; i < jmsResources.length; ++i) {
                ObjectName name = jmsResources[i];
                JMSResourceMBean _jmsMbean = (JMSResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)name, JMSResourceMBean.class, (boolean)false);
                if (_jmsMbean == null) continue;
                this.jmsMbean = _jmsMbean;
                break block3;
            }
        }
        if (this.jmsMbean == null) {
            System.out.println("No jms resource found with the name of " + this.engineName);
            throw new JeusRuntimeException("No jms resource found with the name of " + this.engineName);
        }
    }

    public boolean createQueue(String queueName, String jndiName, String brokerName) {
        try {
            this.jmsMbean.addQueueDestination(queueName, jndiName, brokerName);
        }
        catch (Throwable ex) {
            System.out.println("[JMS] JMSCommander error in createQueue");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createQueue(String queueName, String jndiName) {
        return this.createQueue(queueName, jndiName, null);
    }

    public boolean createTopic(String topicName, String jndiName) {
        try {
            this.jmsMbean.addTopicDestination(topicName, jndiName, null);
        }
        catch (Throwable ex) {
            System.out.println("[JMS] JMSCommander error in createTopic");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteQueue(String queueName) {
        return this.deleteDestination(queueName);
    }

    public boolean deleteTopic(String topicName) {
        return this.deleteDestination(topicName);
    }

    public boolean deleteDestination(String destination) {
        try {
            this.jmsMbean.removeDestination(destination);
        }
        catch (Throwable ex) {
            System.out.println("[JMS] JMSCommander error removing destination " + destination);
            return false;
        }
        return true;
    }

    public boolean addConnectionFactory(String type, String name, String jndiName, int maxThreadNumber, String clientID) {
        try {
            this.jmsMbean.addConnectionFactory(type, name, jndiName, maxThreadNumber, clientID);
        }
        catch (Throwable ex) {
            System.out.println("[JMS] JMSCommander error adding connection factory " + name);
            return false;
        }
        return true;
    }

    public boolean addQueueConnectionFactory(String factoryName, String jndiName) {
        return this.addConnectionFactory("queue", factoryName, jndiName, -1, null);
    }

    public boolean addQueueConnectionFactory(String factoryName, String jndiName, int maxThreads) {
        return this.addConnectionFactory("queue", factoryName, jndiName, maxThreads, null);
    }

    public boolean addTopicConnectionFactory(String factoryName, String jndiName, String clientID) {
        return this.addConnectionFactory("topic", factoryName, jndiName, -1, clientID);
    }

    public boolean addTopicConnectionFactory(String factoryName, String jndiName, int maxThreads, String clientID) {
        return this.addConnectionFactory("topic", factoryName, jndiName, maxThreads, clientID);
    }

    public boolean deleteConnectionFactory(String factoryName) {
        try {
            this.jmsMbean.removeConnectionFactory(factoryName);
        }
        catch (Throwable ex) {
            System.out.println("[JMS] JMSCommander error adding connection factory " + factoryName);
            return false;
        }
        return true;
    }
}

